/*
    icqreadaway.cpp  -  ICQ Protocol Plugin

    Copyright (c) 2003 by Stefan Gehn <metz AT gehn.net>
    Kopete    (c) 2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include "icqreadaway.h"

#include "icqprotocol.h"
#include "icqaccount.h"
#include "icqcontact.h"

#include <tqvbox.h>

#include <ktextbrowser.h>
#include <tdelocale.h>
#include <krun.h>

#include <assert.h>


ICQReadAway::ICQReadAway(ICQContact *c, TQWidget *parent, const char* name)
	: KDialogBase(parent, name, false, TQString(), Close | User1,
		Close, false, i18n("&Fetch Again"))
{
	assert(c);

	mAccount = static_cast<ICQAccount*>(c->account());
	mContact = c;
	setCaption(i18n("'%2' Message for %1").arg(c->displayName()).arg(c->onlineStatus().description()));

	TQVBox *mMainWidget = makeVBoxMainWidget();

	awayMessageBrowser = new KTextBrowser(mMainWidget, "userInfoView");
	awayMessageBrowser->setTextFormat(AutoText);
	awayMessageBrowser->setNotifyClick(true);
	awayMessageBrowser->setText(mContact->awayMessage());

	TQObject::connect(
		awayMessageBrowser, TQT_SIGNAL(urlClick(const TQString&)),
		this, TQT_SLOT(slotUrlClicked(const TQString&)));
	TQObject::connect(
		awayMessageBrowser, TQT_SIGNAL(mailClick(const TQString&, const TQString&)),
		this, TQT_SLOT(slotMailClicked(const TQString&, const TQString&)));

	connect(this, TQT_SIGNAL(user1Clicked()),
		this, TQT_SLOT(slotFetchAwayMessage()));
	connect(this, TQT_SIGNAL(closeClicked()),
		this, TQT_SLOT(slotCloseClicked()));

	connect(c, TQT_SIGNAL(awayMessageChanged()),
		this, TQT_SLOT(slotAwayMessageChanged()));

	slotFetchAwayMessage();
}

void ICQReadAway::slotFetchAwayMessage()
{
	if(!mAccount->isConnected())
		return;

	awayMessageBrowser->setDisabled(true);
	enableButton(User1,false);

	mAccount->engine()->requestAwayMessage(mContact);

	setCaption(i18n("Fetching '%2' Message for %1...").arg(mContact->displayName()).arg(mContact->onlineStatus().description()));
} // END slotFetchAwayMessage()

void ICQReadAway::slotAwayMessageChanged()
{
	setCaption(i18n("'%2' Message for %1").arg(mContact->displayName()).arg(mContact->onlineStatus().description()));
	awayMessageBrowser->setText(mContact->awayMessage());

	awayMessageBrowser->setDisabled(false);
	enableButton(User1,true);

} // END slotAwayMessageChanged()

void ICQReadAway::slotCloseClicked()
{
	emit closing();
}

void ICQReadAway::slotUrlClicked(const TQString &url)
{
	new KRun(KURL(url));
}

void ICQReadAway::slotMailClicked(const TQString&, const TQString &address)
{
	new KRun(KURL(address));
}

#include "icqreadaway.moc"
