/***************************************************************************
                              kchatwidget.cpp
                             -----------------
    Developers: (c) 2000-2001 Nikolas Zimmermann <wildfox@kde.org>
                (c) 2000-2001 Daniel Molkentin <molkentin@kde.org>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeapplication.h>
#include "kchatwidget.moc"

KChatWidget::KChatWidget(TQWidget *parent, const char *name) : chatDlg(parent, name)
{
	connect(sendBtn, TQT_SIGNAL(clicked()), this, TQT_SLOT(slotComputeMessage()));
	connect(commentEdit, TQT_SIGNAL(returnPressed()), this, TQT_SLOT(slotComputeMessage()));
	chatView->setFocusProxy(commentEdit);
	chatView->setMinimumSize(0, 50);
	commentEdit->installEventFilter(this);

	m_currentNickname = TQString();
	slotAcceptMsg(false);
}

void KChatWidget::clear()
{
	m_currentNickname = TQString();
	slotAcceptMsg(false);
	chatView->clear();
	commentEdit->clear();
}

void KChatWidget::slotAcceptMsg(bool value)
{
	m_acceptMsgs = value;
}

void KChatWidget::slotReceivedMessage(const TQString &nickname, const TQString &msg, bool fromenemy)
{
	// Niko Z:
	// IRC roxxx :)
	if(msg.startsWith("/me "))
		chatView->append(TQString(" * ") + nickname + TQString(" ") + msg.mid(4));
	else if(msg.startsWith("/nick "))
		if(fromenemy)
			emit sigChangeEnemyNickname(msg.mid(6));
		else
			emit sigChangeOwnNickname(msg.mid(6));
	else
		chatView->append(nickname + TQString(": ") + msg);
	chatView->setCursorPosition(chatView->numLines(), 0);
}

bool KChatWidget::eventFilter(TQObject *obj, TQEvent *e)
{
	if(TQT_BASE_OBJECT(obj) == TQT_BASE_OBJECT(commentEdit) && e->type() == TQEvent::Wheel)
	{
		kapp->notify(TQT_TQOBJECT(chatView), e);
		return true;
	}
	return chatDlg::eventFilter(obj, e);
}

void KChatWidget::slotComputeMessage()
{
	if(!commentEdit->text().stripWhiteSpace().isEmpty() && m_acceptMsgs)
	{
		slotReceivedMessage(m_currentNickname, commentEdit->text(), false);
		emit sigSendMessage(commentEdit->text());
		commentEdit->setText("");
	}
	else if(commentEdit->text().stripWhiteSpace().isEmpty() && m_acceptMsgs)
		commentEdit->setText("");
	commentEdit->setFocus();
}
