
/***************************************************************************
                          kadddevicecontainer.cpp  -  description
                             -------------------
    begin                : Wed Jun 15 00:40:33 UTC 2005
    copyright            : (C) 2005 by Juan Luis Baptiste
    email                : juan.baptiste@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kadddevicecontainer.h"

KAddDeviceContainer::KAddDeviceContainer(TQWidget *parent, const char *name)
 : KDialog(parent, name)
{
    _modified = false;   
    _advanced = false;
 
     //Setup extension dialog
    setExtension( new KAddDeviceDlgExtension( this ) );
    setOrientation(Qt::Vertical );
   
    //Create dialog that contains the KAddDeviceDlg and KAddDeviceWifiExt (when 
    //configuring a wireless interface) widgets 
    TQPixmap activeEthernetDeviceImg(BarIcon("network_connected_lan_knc"));
    setIcon(activeEthernetDeviceImg);
    //First create a main TQHBoxLayout
    mainLayout = new TQVBoxLayout( this, 10, 2, "mainLayout"); 
    
    //Create the Addvanced settings, Ok and Cancel buttons and add them to a TQHBoxLayout
    buttonsLayout = new TQHBoxLayout( 0, 0, 4, "buttonsLayout"); 
    kpbAdvanced = new KPushButton( this, "kpbAdvanced" );
    buttonsLayout->addWidget( kpbAdvanced );
    buttonsSpacer = new TQSpacerItem( 70, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    buttonsLayout->addItem( buttonsSpacer );

    kpbApply = new KPushButton( this, "kpbApply" );
    kpbApply->setEnabled( FALSE );
    kpbApply->setDefault( TRUE );
    buttonsLayout->addWidget( kpbApply );

    kpbCancel = new KPushButton( this, "kpbCancel" );
    buttonsLayout->addWidget( kpbCancel );
            
    setCaption( TQString() );
    kpbAdvanced->setText( i18n( "&Advanced Settings" ) );
    TQToolTip::add( kpbAdvanced, i18n( "Toggle between advanced and basic settings" ) );
    TQWhatsThis::add( kpbAdvanced, i18n( "Toggle between advanced and basic settings" ) );
    kpbApply->setText( i18n( "&OK" ) );
    TQToolTip::add( kpbApply, i18n( "Apply changes" ) );
    kpbCancel->setText( i18n( "&Cancel" ) );
    TQToolTip::add( kpbCancel, i18n( "Forget changes" ) );

    //Creat and add the KAddDeviceDlg widget to the main layout
    addDlg = new KAddDeviceDlg(this);
    mainLayout->addWidget(addDlg);
    mainLayout->setResizeMode(TQLayout::Auto);
    
    //Setup connections
    connect((KAddDeviceDlgExtension*)extension(),TQT_SIGNAL(valueChangedSignal(int)),this,TQT_SLOT(toggleApplyButtonSlot(int)));
    connect(addDlg->kleIPAddress,TQT_SIGNAL(textChanged(const TQString&)),this,TQT_SLOT(toggleApplyButtonSlot(const TQString&)));
//    connect(addDlg->kleGateway,TQT_SIGNAL(textChanged(const TQString&)),this,TQT_SLOT(toggleApplyButtonSlot(const TQString&)));
    connect(addDlg->kcbNetmask,TQT_SIGNAL(activated(int)),this,TQT_SLOT(toggleApplyButtonSlot(int)));
    connect(addDlg->kcbAutoBootProto,TQT_SIGNAL(activated(const TQString&)),this,TQT_SLOT(toggleApplyButtonSlot(const TQString&)));
    connect(addDlg->kcbstartAtBoot,TQT_SIGNAL(stateChanged(int)),this,TQT_SLOT(toggleApplyButtonSlot(int)));
    connect(addDlg->rbBootProtoAuto,TQT_SIGNAL(toggled(bool)),this,TQT_SLOT(toggleAdvancedOptionsSlot(bool)));
    connect(addDlg->rbBootProtoAuto,TQT_SIGNAL(toggled(bool)),kpbAdvanced,TQT_SLOT(setDisabled(bool)));
    connect(addDlg->rbBootProtoAuto,TQT_SIGNAL(stateChanged(int)),this,TQT_SLOT(toggleApplyButtonSlot(int)));
   // connect(addDlg->rbBootProtoAuto,TQT_SIGNAL(toggled(bool)),addDlg->kleIPAddress,TQT_SLOT(setDisabled(bool)));
   // connect(addDlg->rbBootProtoAuto,TQT_SIGNAL(toggled(bool)),addDlg->kcbNetmask,TQT_SLOT(setDisabled(bool)));        
   // connect(addDlg->rbBootProtoManual,TQT_SIGNAL(toggled(bool)),addDlg->kcbAutoBootProto,TQT_SLOT(setDisabled(bool)));
    connect(kpbCancel,TQT_SIGNAL(clicked()),this,TQT_SLOT(cancelSlot()));
    connect(kpbApply,TQT_SIGNAL(clicked()),this,TQT_SLOT(verifyDeviceInfoSlot()));
    connect(kpbAdvanced,TQT_SIGNAL(clicked()),this,TQT_SLOT(advancedOptionsSlot()));
    
}

void KAddDeviceContainer::addWirelessWidget(){
  extDlg = new KAddDeviceWifiExt(this);
  mainLayout->addWidget( extDlg );
  connect(extDlg->kleEssid,TQT_SIGNAL(textChanged(const TQString&)),this,TQT_SLOT(toggleApplyButtonSlot(const TQString&)));
  connect(extDlg->kleWepKey,TQT_SIGNAL(textChanged(const TQString&)),this,TQT_SLOT(toggleApplyButtonSlot(const TQString&)));
  connect(extDlg->qcbKeyType,TQT_SIGNAL(activated(const TQString&)),this,TQT_SLOT(toggleApplyButtonSlot(const TQString&)));
}
void KAddDeviceContainer::toggleApplyButtonSlot( const TQString & )
{
  toggleApplyButtonSlot(0);
}

void KAddDeviceContainer::toggleApplyButtonSlot( int )
{
  _modified = true;
   kpbApply->setEnabled(true);
}

void KAddDeviceContainer::toggleAdvancedOptionsSlot(bool enabled )
{
   KAddDeviceDlgExtension *advancedOptions = (KAddDeviceDlgExtension *)this->extension();

  if (enabled)
    advancedOptions->gbAdvancedDeviceInfo->setEnabled(false);
  else
    advancedOptions->gbAdvancedDeviceInfo->setEnabled(true);
  
  _modified = true;
  kpbApply->setEnabled(true);
}

void KAddDeviceContainer::verifyDeviceInfoSlot()
{
  KAddDeviceDlgExtension *advancedOptions = (KAddDeviceDlgExtension *)this->extension();
  
  if (addDlg->rbBootProtoManual->isChecked())
  {	
    TQString ipAddress = addDlg->kleIPAddress->text();
    TQString netmask = addDlg->kcbNetmask->currentText();
    TQString broadcast = advancedOptions->kleBroadcast->text();
    TQString gateway = advancedOptions->kleGateway->text();
    
    if (!KAddressValidator::isValidIPAddress(ipAddress))
    {
      KMessageBox::error(this,i18n("The format of the specified IP address is not valid."),i18n("Invalid IP Address"));
    }    
    else if (_advanced && !KAddressValidator::isNetmaskValid(netmask))
        KMessageBox::error(this,i18n("The format of the specified netmask is not valid."),i18n("Invalid IP Address"));
        
    else if (!broadcast.isEmpty() && _advanced && !KAddressValidator::isBroadcastValid(broadcast))
        KMessageBox::error(this,i18n("The format of the specified broadcast is not valid."),i18n("Invalid IP Address"));
    
    else if (!gateway.isEmpty() && _advanced && !KAddressValidator::isValidIPAddress(gateway))
        KMessageBox::error(this,i18n("The format of the specified Gateway is not valid."),i18n("Invalid IP Address"));
        
    else
    {
      _modified = true;
      close();
    }
  }	
  else if (addDlg->rbBootProtoAuto->isChecked())
  {
    _modified = true;
    close();
  }    
}

void KAddDeviceContainer::makeButtonsResizeable()
{
  kpbApply->setAutoResize(true);
  kpbAdvanced->setAutoResize(true);
  kpbCancel->setAutoResize(true);
}

bool KAddDeviceContainer::modified()
{
  return _modified;
}
bool KAddDeviceContainer::advanced()
{
  return _advanced;
}


void KAddDeviceContainer::advancedOptionsSlot()
{
    if (!_advanced)
    {
      kpbAdvanced->setText(i18n("Basic Settings"));
      addDlg->kcbNetmask->setEditable(true);	
    }
    else
    {
      kpbAdvanced->setText(i18n("Advanced Settings"));
      addDlg->kcbNetmask->setEditable(false);      
    }
    _advanced = !_advanced;
    showExtension(_advanced );  
}


void KAddDeviceContainer::cancelSlot()
{
 _modified = false;
 close();
}


KAddDeviceContainer::~KAddDeviceContainer()
{
}

void KAddDeviceContainer::addButtons()
{
  widgetHSpacer = new TQSpacerItem( 20, 16, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
  mainLayout->addItem( widgetHSpacer );  
  mainLayout->addLayout( buttonsLayout );
}

#include "kadddevicecontainer.moc"
