
/***************************************************************************
 *                                                                         *
 *   KCPULoad and KNetLoad are copyright (c) 1999-2000, Markus Gustavsson  *
 *                                       (c) 2002, Ben Burton              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "speeddialog.h"

#include <cstdlib>
#include <kcombobox.h>
#include <tdelocale.h>
#include <tqlabel.h>
#include <tqhbox.h>
#include <tqvalidator.h>

static int stockSpeed[] = {
    100, 150, 200, 250, 300, 400, 600, 800, 1000, 1200, 1500, 2000, 2500,
    3000, 4000, 5000, 0
};

SpeedDialog::SpeedDialog(int defaultSpeed, TQWidget* parent) :
        KDialogBase(parent, "speed dialog", true,
        i18n("Select Speed"), Ok|Cancel, Ok),
        speed(defaultSpeed) {
    TQHBox* page = makeHBoxMainWidget();

    new TQLabel(i18n("Update interval in milliseconds:"), page);

    KComboBox* speedBox = new KComboBox(true, page);

    TQIntValidator* val = new TQIntValidator(TQT_TQOBJECT(this));
    val->setBottom(1);
    speedBox->setValidator(val);

    TQString speedStr;
    for (int i = 0; stockSpeed[i]; i++) {
        speedStr.setNum(stockSpeed[i]);
        speedBox->insertItem(speedStr);
    }

    speedStr.setNum(defaultSpeed);
    speedBox->setCurrentText(speedStr);

    connect(speedBox, TQT_SIGNAL(textChanged(const TQString&)),
        this, TQT_SLOT(updateSpeed(const TQString&)));
}

int SpeedDialog::getSpeed() const {
    return speed;
}

void SpeedDialog::updateSpeed(const TQString& text) {
    speed = text.toInt();
}

#include "speeddialog.moc"
