/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _SIGTOOL_H_
#define _SIGTOOL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdemainwindow.h>



class KPrinter;
class TDEToggleAction;
class KURL;
class TQLineEdit;
class TQComboBox;
class TQCheckBox;
class TQListBox;
class TQPushButton;
class TQLabel;
class TQTextBrowser;
class TDEProcess;
class TDEConfig;
class KURLRequester;


/**
 * This class serves as the main window for Sigtool.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Sigtool :  public TQWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Sigtool(TQWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Sigtool();

    /**
     * Use this method to load whatever file/URL you have
     */
    void  setDirName(TQString);

protected:
    /**
     * Overridden virtuals for TQt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(TQDragEnterEvent *event);
    virtual void dropEvent(TQDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(TDEConfig *);

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(TDEConfig *);


private slots:
/*    void fileNew();
    void fileOpen();
    void fileSave();
    void fileSaveAs();
    void filePrint();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
*/
    //void changeStatusbar(const TQString& text);
    //void changeCaption(const TQString& text);

private:
    void setupAccel();
    void setupActions();

private:
    //SigtoolView *m_view;

  /*  KPrinter   *m_printer;
    TDEToggleAction *m_toolbarAction;
    TDEToggleAction *m_statusbarAction;*/


signals:
    void itemSelected(TQString abs_filename, int line);

public slots:

private slots:
    void configureKMail();
    void manualKMail();
    void manualEvolution();
    void manual();
    void dobuttons();
private:

    TQLineEdit *template_edit;
    TQComboBox *files_combo, *pattern_combo/*, *dir_combo*/;
    KURLRequester *dir_combo;
    TQCheckBox *recursive_box;
    TQListBox *resultbox;
    TQPushButton *search_button, *manual_button;
    TQLabel *status_label, *matches_label;
    TDEProcess *childproc;
    TQString buf;
    TDEConfig *config;
    TQStringList lastSearchItems;
    TQStringList lastSearchPaths;
    TQComboBox *check_combo;
    TQTextBrowser *notes_browser;
};

#endif // _Sigtool_H_
