/***************************************************************************
begin                : 2004/02/07
copyright            : (C) Mark Kretschmann
email                : markey@web.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "klamav.h"
#include "configdialog.h"
#include "backend.h"
#include "archives.h"
#include "specialfiletypes.h"
#include "klamonacc.h"
#include "klamonacc_config.h"
#include "logoptions.h"
#include "sigtool.h"

#include <tqcombobox.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqmessagebox.h>
#include <tqobjectlist.h>
#include <tqpushbutton.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqtextcodec.h>
#include <tqtooltip.h>
#include <tqvbox.h>

#include <tdeapplication.h> //kapp
#include <kcombobox.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <tdelocale.h>
#include <kstandarddirs.h>
#include <tdemessagebox.h>

//////////////////////////////////////////////////////////////////////////////////////////
// PUBLIC
//////////////////////////////////////////////////////////////////////////////////////////

KlamavConfigDialog::KlamavConfigDialog( TQWidget *parent, const char* name, TDEConfigSkeleton *config )
        : TDEConfigDialog( parent, name, config )
{
    setWFlags( WDestructiveClose );

    // IMPORTANT Don't simply change the page names, they are used as identifiers in other parts of the app.
            m_klambackend = new KlamBackend( 0, "Scanning Backend" );
            m_archives = new ArchiveOptions( 0, "Archives" );
	    m_emailprotection = new Sigtool ( 0, "E-mail protection" );
            m_specialfiletypes = new SpecialFileTypes( 0, "File Types" );
	    m_klamonacc = new KlamOnAccConfig( 0, "On-Access Scanner" );
	    m_logoptions = new LogOptions( 0, "Event Logging" );

    // add pages
    addPage( m_klambackend, i18n( "Backend" ), "system-run", i18n( "Configure Scanning Backend" ) );
    connect( m_klambackend->kcfg_ScannerClamdscan, SIGNAL(toggled(bool)), this, SLOT(slotToggleClamdscan(bool)) );
    slotToggleClamdscan( m_klambackend->kcfg_ScannerClamdscan->isOn() ); // initial state

    addPage( m_archives, i18n( "Archives" ), "ark", i18n( "Configure Archive Scanning" ) );
    addPage( m_emailprotection, i18n( "E-mail protection" ), "email", i18n( "Set up your e-mail client to use Klammail" ) );
    addPage( m_specialfiletypes, i18n( "File Types" ), "folder", i18n( "Configure File Types" ) );

    addPage( m_klamonacc, i18n( "On-Access Scanner" ), "filefind", i18n( "Configure On-Access Scanning" ) );
    connect( m_klamonacc, SIGNAL(directoriesModified()), tdemain->klamonacc, SLOT(restart()) );
    connect( tdemain->klamonacc, SIGNAL(stateUpdated()), this, SLOT(slotToggleKlamOnAccCheckbox()) );
    connect( m_klamonacc->kcfg_EnableOnAccess, SIGNAL(toggled(bool)), this, SLOT(slotToggleKlamOnAcc(bool)) );
    slotToggleKlamOnAcc( m_klamonacc->kcfg_EnableOnAccess->isOn() ); // initial state

    addPage( m_logoptions, i18n( "Event Logging" ), "kate", i18n( "Configure Events to Log" ) );

    TQObjectList *list = queryList( "TQLabel", "infoPixmap" );
    for( TQObject *label = list->first(); label; label = list->next() )
        static_cast<TQLabel*>(label)->setPixmap( TQMessageBox::standardIcon( TQMessageBox::Information ) );
    delete list;

    //stop TDEFont Requesters getting stupidly large
    list = queryList( "TQLabel", "m_sampleLabel" );
    for( TQObject *label = list->first(); label; label = list->next() )
        static_cast<TQLabel*>(label)->setMaximumWidth( 250 );
    delete list;

    connect( this, SIGNAL(settingsChanged()), SLOT(applySettings()) );
}

KlamavConfigDialog::~KlamavConfigDialog()
{
}

void KlamavConfigDialog::slotToggleClamdscan(bool on)
{
        m_klambackend->kcfg_ClamdMultiscan->setEnabled(on);
        m_archives->setEnabled(!on);
        m_specialfiletypes->setEnabled(!on);
}

void KlamavConfigDialog::slotToggleKlamOnAcc(bool on)
{
    m_klamonacc->kcfg_ExtraScanning->setEnabled(on);
    m_klamonacc->kcfg_OnAccessMaxFile->setEnabled(on);
//     m_klamonacc->kcfg_ExcludeConfDir->setEnabled(on);
    m_klamonacc->GroupWatchDirs->setEnabled(on);
}

void KlamavConfigDialog::slotToggleKlamOnAccCheckbox()
{
    m_klamonacc->kcfg_EnableOnAccess->setChecked( tdemain->klamonacc->isEnabled() );
}

/** Show page by object name */
void KlamavConfigDialog::showPage( const TQCString& page )
{
    for( uint index = 0; index < m_pageList.count(); index++ ) {
        if ( m_pageList[index]->name() == page ) {
            TDEConfigDialog::showPage( index );
            return;
        }
    }
}

/** Reimplemented from TDEConfigDialog */
void KlamavConfigDialog::addPage( TQWidget *page, const TQString &itemName, const TQString &pixmapName, const TQString &header, bool manage )
{
    // Add the widget pointer to our list, for later reference
    m_pageList << page;

    TDEConfigDialog::addPage( page, itemName, pixmapName, header, manage );
}

void KlamavConfigDialog::applySettings() {
    // Some precautions
    // if(! m_klamonacc->kcfg_ExcludeConfDir->isOn() )
    //    KMessageBox::information(this, i18n("You have chosen not to exclude the TDE configuration directory from the on-access scanner's watchlist. Be warned that watching this directory can severely impact your computer's performance and cause instability."), i18n("Warning!") );

    // Toggle/restart Klamonacc
    bool oldState = tdemain->klamonacc->isEnabled();
    bool newState = m_klamonacc->kcfg_EnableOnAccess->isOn();

    if( oldState != newState ) // If Klamonacc's state changed
        tdemain->klamonacc->toggle( newState );
    else if( newState && m_klamonacc->needsRestart() ) { // If KlamOnAcc's settings were changed
        tdemain->klamonacc->restart();
        m_klamonacc->slotSettingsApplied();
    }
}




#include "configdialog.moc"
