#################################################
#
#  (C) 2010 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#  Modified by Mavridis Philippe for KlamAV.
#
#################################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )

find_package( X11 )


##### check for LibClamAV

pkg_search_module( LIBCLAMAV libclamav>=0.102.0 )

if( NOT LIBCLAMAV_FOUND )
     tde_message_fatal( "ClamAV is required but not found on your system" )
endif( NOT LIBCLAMAV_FOUND )


##### check for zlib (needed by Virus Browser)

pkg_search_module( ZLIB zlib )

if( NOT ZLIB_FOUND )
     tde_message_fatal( "zlib is required but not found on your system" )
endif( NOT ZLIB_FOUND )


##### check whether to use embedded or system SQLite

if( WITH_EMBEDDED_SQLITE )
     set( SQLITE_LIBRARIES sqlite-static )
     message( STATUS "sqlite3 linking: ${SQLITE_LIBRARIES}" )
else()
     pkg_search_module( SQLITE sqlite3 )

     if( SQLITE_FOUND )
          message( STATUS "sqlite3 linking: ${SQLITE_LIBRARIES}" )
     else()
          tde_message_fatal( "sqlite3 is required, but not found on your system" )
     endif( SQLITE_FOUND )
endif( WITH_EMBEDDED_SQLITE )
