/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_PIXMAP_LABEL_H
#define KBFX_PIXMAP_LABEL_H

#include <tqlabel.h>
#include <kdebug.h>
#include <tqdragobject.h>
#include <tqtooltip.h>

class KbfxPixmapLabel : public TQLabel
{
		Q_OBJECT
  

	public:
		KbfxPixmapLabel ( TQWidget *parent = 0, const char *name = 0, WFlags f = 0 );
		~KbfxPixmapLabel ();

		void dragEnterEvent ( TQDragEnterEvent *mouseDragEnterEvent );
		void dropEvent ( TQDropEvent *mouseDropEvent );
		void mousePressEvent ( TQMouseEvent * e );
		void mouseDoubleClickEvent ( TQMouseEvent * e );
		void normalize ();

	signals:
		void targetDrop ( const TQString & );
		void clicked();
		void mouseClicked ();
		void mouseClicked ( const ButtonState & );
		void mouseDoubleClicked ();
		void mouseDoubleClicked ( const ButtonState & );
};

#endif // KBFX_PIXMAP_LABEL_H
