#include <cstddef>
#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>

#include <tagcoll/patch.tcc>

#include <adept/quickfilter.h>
#include <adept/statefilter.h>
#include <adept/tagfilter.h>

#include <adept/packagedetails.h>
#include <adept/view.h>
#include <adept/filtersidebar.h>

using namespace adept;

View::View( TQWidget *p, const char *n )
    : TQSplitter( p, n )
{
    setOrientation( Qt::Vertical );
    m_flist = new FilterList( this );
    m_bottom = new TQSplitter( this );
    m_bottom->setOrientation( Qt::Horizontal );
    m_lister = new Lister( m_bottom );
    m_flist->plugLister( m_lister );
    m_sidebar = new FilterSidebar( m_bottom );

    connect( m_lister, TQT_SIGNAL( cardinalityChanged( const Lister::Cardinality & ) ),
             m_sidebar, TQT_SLOT( setCardinality( const Lister::Cardinality & ) ) );

    m_flist->setHiddenPredicate(
        predicate::adapt< entity::Entity >(
            predicate::Package::member( &entity::Package::hasVersion ) ) );
    m_flist->appendPredicate(
        predicate::adapt< entity::Entity >(
            StateFilter< entity::Package >() ) );
    m_flist->appendPredicate(
        predicate::adapt< entity::Entity >(
            TagFilter< entity::Package >() ) );
    m_flist->appendPredicate(
        predicate::adapt< entity::Entity >(
            QuickFilter< entity::Package >() ) );

    m_lister->setRangeProvider( this );

    TQTimer::singleShot( 0, this, TQT_SLOT( delayed() ) );
}

Lister::Range View::listerRange() {
    component::Packages &cp = cache::Global::get().packages();
    return cp.sorted();
    // return range( cp.packagesBegin(), cp.packagesEnd() );
}

void View::hideTags() {
    TQValueList< int > szl;
    szl.append( 0 ); szl.append( 1 );
    setSizes( szl );
}

void View::hideFilters() {
    TQValueList< int > szl;
    szl.append( 1 ); szl.append( 0 );
    m_bottom->setSizes( szl );
}

predicate::Predicate< entity::Entity > View::previewPredicate()
{
    return predicate::adapt< entity::Entity >(
        (not predicate::Package::member( &entity::Package::markedKeep ))
        or predicate::Package::member( &entity::Package::isBroken )
        or predicate::Package::member( &entity::Package::willBreak ) );
}

void View::setUpgradeMode()
{
    setPreviewMode();
    filterList()->setHiddenPredicate(
        previewPredicate() or predicate::adapt< entity::Entity >(
            predicate::Package::member( &entity::Package::isUpgradable ) ) );
}

void View::setPreviewMode()
{
    filterList()->setHiddenPredicate( previewPredicate() );
    hideFilters();
    hideTags();
}
    
void View::delayed()
{
    // cleanRebuild();
}

Browser::Browser( TQWidget *p, const char *n )
    : TQWidgetStack( p, n ), m_currentValid( false )
{
    m_current = entity::Entity();
    addWidget( m_view = new View( this ) );
    addWidget( m_details = new PackageDetails( this ) );
    connect( m_view->lister(), TQT_SIGNAL( detailsRequested( Lister::Entity ) ),
             this, TQT_SLOT( show( Lister::Entity ) ) );
    connect( m_details, TQT_SIGNAL( showList() ),
             this, TQT_SLOT( showList() ) );
    connect( m_details, TQT_SIGNAL( back() ),
             this, TQT_SLOT( back() ) );
    connect( m_details, TQT_SIGNAL( forward() ),
             this, TQT_SLOT( forward() ) );
    connect( m_details, TQT_SIGNAL( detailsRequested( Lister::Entity ) ),
             this, TQT_SLOT( show( Lister::Entity ) ) );
}

void Browser::showList()
{
    raiseWidget( m_view );
}

void Browser::back()
{
    m_forward.push_back( m_current );
    m_current = m_back.back();
    m_back.pop_back();
    doShow( m_current );
}

void Browser::forward()
{
    m_back.push_back( m_current );
    m_current = m_forward.back();
    m_forward.pop_back();
    doShow( m_current );
}

void Browser::doShow( Lister::Entity e )
{
    m_details->setHasForward( !m_forward.empty() );
    m_details->setHasBack( !m_back.empty() );
    raiseWidget( m_details );
    m_details->setPackage( downcast< entity::Package >( e ) );
}

void Browser::show( Lister::Entity e )
{
    m_forward.clear();
    if ( m_currentValid )
        m_back.push_back( m_current );
    m_currentValid = true;
    m_current = e.stable();
    doShow( e );
}

/* Kolik existencialistu je potreba k zasroubovani zarovky?
   Dva. Jeden sroubuje zarovku, a druhy premysli jak zarovka
   sama o sobe predstavuje jednotlivy zarivy bod v subjektivni
   realite v podsveti nekonecne absurdity dosahujici neuprimny
   vesmir nicoty. */
