/** -*- C++ -*-
    @file adept/utils.h
    @author Peter Rockai <me@mornfall.net>
*/

#include <tqthread.h>
#include <tqstring.h>
#include <tdeapplication.h>
#include <string>
#include <queue>
#include <kdebug.h>

#ifndef EPT_UTILS_H
#define EPT_UTILS_H

namespace adept {

inline TQString u8( std::string s ) {
    return TQString::fromUtf8( s.c_str() );
}

inline std::string u8( TQString s ) {
    return std::string( s.utf8() );
}

inline TQString u8( const char *s ) {
    return TQString::fromUtf8( s );
}

struct Threads {
    static TQMutex serialize;
    typedef std::deque< std::pair< TQThread *, TQMutex * > > Queue;
    static Queue threads;
    static void enqueue( TQThread *t, TQMutex *m );
    static void wait();
};

template< typename F, typename P >
struct AsyncCall : public TQThread
{
    AsyncCall( F f, P p ) : func( f ), param( p ) {}
    virtual void run()
    {
        // kdDebug() << "Thread waiting for mutex..." << endl;
        Threads::serialize.lock();
        // kdDebug() << "starting thread (mutex acquired)" << endl;
        func( param );
        // kdDebug() << "finishing thread (releasing mutex)" << endl;
        Threads::serialize.unlock();
    }
    virtual ~AsyncCall() {}
protected:
    F func;
    P param;
};


template< typename F, typename P > AsyncCall< F, P > *asyncCall( F f, P p ) {
    return new AsyncCall< F, P >( f, p );
}

inline static void adjustFontSize( TQWidget *w, int off ) {
    TQFont f = w->font();
    f.setPointSize( f.pointSize() + off ); // a bit smaller font...
    w->setFont( f );
    w->updateGeometry();
}

}

#endif
