/***************************************************************************
 *
 * knetworkmanager-gsm_connection.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include "knetworkmanager-gsm_connection.h"

#include <nm-setting-gsm.h>
#include "knetworkmanager-connection_setting_serial.h"

ConnectionSettings::GSMConnection::GSMConnection()
    : PPPConnection(NM_SETTING_GSM_SETTING_NAME)
{
	appendSetting(new GSM(this));
	appendSetting(new Serial(this));
}

ConnectionSettings::GSMConnection::~GSMConnection()
{

}

ConnectionSettings::GSM* ConnectionSettings::GSMConnection::getGSMSetting() const
{
	return dynamic_cast<GSM*>(getSetting(NM_SETTING_GSM_SETTING_NAME));
}

ConnectionSettings::Serial* ConnectionSettings::GSMConnection::getSerialSetting() const
{
	return dynamic_cast<Serial*>(getSetting(NM_SETTING_SERIAL_SETTING_NAME));
}

ConnectionSettings::Connection* ConnectionSettings::GSMConnection::duplicate()
{
	GSMConnection* conn = new GSMConnection();
	conn->updateSettings(this);
	return conn;
}
#include "knetworkmanager-gsm_connection.moc"
