/***************************************************************************
 *
 * knetworkmanager-connection_setting_gsm_widget.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// qt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqiconset.h>
#include <kiconloader.h>
#include <tqwidgetstack.h>
#include <kuser.h>

// knm headers
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_gsm.h"
#include "knetworkmanager-connection_setting_gsm_widget.h"
#include "knetworkmanager-device.h"

#include "connection_setting_gsm.h"

using namespace ConnectionSettings;

GSMWidgetImpl::GSMWidgetImpl(Connection* conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_gsmsetting = dynamic_cast<ConnectionSettings::GSM*> (conn->getSetting(NM_SETTING_GSM_SETTING_NAME));

	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingGsmWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
GSMWidgetImpl::Init()
{
    _mainWid->mUsername->setText( _gsmsetting->getUsername() );
    _mainWid->mPassword->setText( _gsmsetting->getPassword( ) );
    _mainWid->mPin->setText( _gsmsetting->getPin() );
    _mainWid->mPuk->setText( _gsmsetting->getPuk() );
    _mainWid->mNumber->setText( _gsmsetting->getNumber() );
    _mainWid->mApn->setText( _gsmsetting->getAPN() );
    _mainWid->mNetworkId->setText( _gsmsetting->getNetworkID( ));
    _mainWid->mNetworkType->setCurrentItem( _gsmsetting->getNetworkType( ) +1);
    _mainWid->mBand->setValue( _gsmsetting->getBand() );

    connect( _mainWid->mUsername, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
    connect( _mainWid->mPassword, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
    connect( _mainWid->mPin, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
    connect( _mainWid->mPuk, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
    connect( _mainWid->mNumber, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
    connect( _mainWid->mApn, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
    connect( _mainWid->mNetworkId, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
    connect( _mainWid->mNetworkType, TQT_SIGNAL(activated(int)), TQT_SLOT(dirty()));
    connect( _mainWid->mBand, TQT_SIGNAL(valueChanged(int)), TQT_SLOT(dirty()));
}

void
GSMWidgetImpl::Deactivate()
{
}

void
GSMWidgetImpl::Activate()
{

}

void
GSMWidgetImpl::dirty()
{
    _gsmsetting->setUsername( _mainWid->mUsername->text() );
    _gsmsetting->setPassword( _mainWid->mPassword->text() );
    _gsmsetting->setPin( _mainWid->mPin->text() );
    _gsmsetting->setPuk( _mainWid->mPuk->text() );
    _gsmsetting->setNumber( _mainWid->mNumber->text() );
    _gsmsetting->setAPN( _mainWid->mApn->text() );
    _gsmsetting->setNetworkID( _mainWid->mNetworkId->text() );
    _gsmsetting->setNetworkType( _mainWid->mNetworkType->currentItem() - 1 );
    _gsmsetting->setBand( _mainWid->mBand->value() );
}

#include "knetworkmanager-connection_setting_gsm_widget.moc"
