/***************************************************************************
                          kbswitchtrayicon.h  -  description
                             -------------------
    begin                : Wed Jul 4 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBSWITCHTRAYICON_H
#define KBSWITCHTRAYICON_H

#include <ksystemtray.h>

#include "kbgroup.h"
#include "kbconfig.h"

/**The tray icon showing the current keyboard group
  *@author Leonid Zeitlin
  */

class KBSwitchTrayIcon : public KSystemTray  {
  Q_OBJECT
public: 
	KBSwitchTrayIcon(KBConfig *conf);
	~KBSwitchTrayIcon();
  /** No descriptions */
  void setToggleGroups(int group1, int group2);
  /** No descriptions */
  void reconfigure();
  /** Update the tray icon display for the given group */
  void updateTrayIcon(int groupno);
signals:
  void groupSelected(int groupno);	
  /** No descriptions */
  void clicked();
  /** No descriptions */
  void preferencesSelected();
private slots: // Private slots
  /** No descriptions */
  void slotMenuActivated(int id);
  /** Display help */
  void slotHelp();
private: // Private attributes
  /**  */
  KBConfig *m_kbconf;
protected: // Protected methods
  /** No descriptions */
  void mouseReleaseEvent(TQMouseEvent *event);
public slots: // Public slots
  /** No descriptions */
  void slotAbout();
  /** Update menu and tray icons after configuration has changed */
  void slotUpdateIcons();
private: // Private methods
  /** No descriptions */
  void addLayoutItems(TDEPopupMenu *menu, bool clearOld);
  /** No descriptions */
  void updateMenuIcons();
  /** No descriptions */
  void setActiveGroup(int groupno);
};

#endif
