/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "configwidget.h"

#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdeaccelmanager.h>

#include <tqvgroupbox.h>
#include <tqlayout.h>

using Tellico::Fetch::ConfigWidget;

ConfigWidget::ConfigWidget(TQWidget* parent_) : TQWidget(parent_), m_modified(false), m_accepted(false) {
  TQHBoxLayout* boxLayout = new TQHBoxLayout(this);
  boxLayout->setSpacing(10);

  TQGroupBox* vbox = new TQVGroupBox(i18n("Source Options"), this);
  boxLayout->addWidget(vbox, 10 /*stretch*/);

  m_optionsWidget = new TQWidget(vbox);
}

void ConfigWidget::addFieldsWidget(const StringMap& customFields_, const TQStringList& fieldsToAdd_) {
  if(customFields_.isEmpty()) {
    return;
  }

  TQVGroupBox* box = new TQVGroupBox(i18n("Available Fields"), this);
  static_cast<TQBoxLayout*>(layout())->addWidget(box);
  for(StringMap::ConstIterator it = customFields_.begin(); it != customFields_.end(); ++it) {
    TQCheckBox* cb = new TQCheckBox(it.data(), box);
    m_fields.insert(it.key(), cb);
    if(fieldsToAdd_.contains(it.key())) {
      cb->setChecked(true);
    }
    connect(cb, TQT_SIGNAL(clicked()), TQT_SLOT(slotSetModified()));
  }

  TDEAcceleratorManager::manage(this);

  return;
}

void ConfigWidget::saveFieldsConfig(TDEConfigGroup& config_) const {
  TQStringList fields;
  for(TQDictIterator<TQCheckBox> it(m_fields); it.current(); ++it) {
    if(it.current()->isChecked()) {
      fields << it.currentKey();
    }
  }
  config_.writeEntry(TQString::fromLatin1("Custom Fields"), fields);
}

#include "configwidget.moc"
