/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000 theKompany.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef TKCOLORACTION_H
#define TKCOLORACTION_H

#include "ttdeaction.h"
#include <koffice_export.h>
#include <tdepopupmenu.h>
#include <tqdict.h>

class TQGridLayout;
class TKColorPanel;
class TTDESelectColorActionPrivate;

class TKColorPopupMenu : public TDEPopupMenu
{ Q_OBJECT
  
public:
  TKColorPopupMenu( TQWidget* parent = 0, const char* name = 0 );
  ~TKColorPopupMenu();

public slots:
  void updateItemSize();
};
/****************************************************************************************/
class KOFFICEUI_EXPORT TTDESelectColorAction : public TTDEAction
{ Q_OBJECT
  
public:
  enum Type {
    TextColor,
    LineColor,
    FillColor,
    Color
  };

  TTDESelectColorAction( const TQString& text, Type type, TQObject* parent, const char* name, bool menuDefaultColor=false);
  TTDESelectColorAction( const TQString& text, Type type,
                       TQObject* receiver, const char* slot,
                       TQObject* parent, const char* name,bool menuDefaultColor=false );

  virtual ~TTDESelectColorAction();

  TQColor color() const { return m_pCurrentColor; }

  TDEPopupMenu* popupMenu() const { return m_pMenu; }
  void setDefaultColor(const TQColor &_col);


public slots:
  void setCurrentColor( const TQColor& );
  void setActiveColor( const TQColor& );
  virtual void activate();

signals:
  void colorSelected( const TQColor& );

protected slots:
  void selectColorDialog();
  void panelColorSelected( const TQColor& );
  void panelReject();
  virtual void slotActivated();
  void defaultColor();

protected:
  void init();
  virtual void initToolBarButton(TTDEToolBarButton*);
  void updatePixmap();
  void updatePixmap(TTDEToolBarButton*);

protected:
  TKColorPopupMenu* m_pMenu;
  TKColorPanel* m_pStandardColor;
  TKColorPanel* m_pRecentColor;
  int m_type;

  TQColor m_pCurrentColor;

private:
  TTDESelectColorActionPrivate *d;
};
/****************************************************************************************/
class TKColorPanelButton : public TQFrame
{ Q_OBJECT
  
public:
  TKColorPanelButton( const TQColor&, TQWidget* parent, const char* name = 0 );
  ~TKColorPanelButton();

  void setActive( bool );

  TQColor panelColor() const { return m_Color; }

signals:
  void selected( const TQColor& );

protected:
  virtual void paintEvent( TQPaintEvent* );
  virtual void enterEvent( TQEvent* );
  virtual void leaveEvent( TQEvent* );
  virtual void mouseReleaseEvent( TQMouseEvent* );

  TQColor m_Color;
  bool m_bActive;

private:
  class TKColorPanelButtonPrivate;
  TKColorPanelButtonPrivate *d;
};
/****************************************************************************************/
class TKColorPanel : public TQWidget
{ Q_OBJECT
  

public:
  TKColorPanel( TQWidget* parent = 0L, const char* name = 0 );
  ~TKColorPanel();

  void setActiveColor( const TQColor& );
  void setNumCols( int col );
  void clear();

public slots:
  void insertColor( const TQColor& );
  void insertColor( const TQColor&, const TQString& );
  void selected( const TQColor& );

signals:
  void colorSelected( const TQColor& );
  void reject();
  void sizeChanged();

protected:
  void addToGrid( TKColorPanelButton* );
  void resetGrid();

  virtual void mouseReleaseEvent( TQMouseEvent* );
  virtual void showEvent( TQShowEvent *e );

  TQGridLayout* m_pLayout;
  int m_iWidth;
  int m_iX;
  int m_iY;

  TQColor m_activeColor;
  TQDict<TKColorPanelButton> m_pColorDict;

private:
  void fillPanel();

  class TKColorPanelPrivate;
  TKColorPanelPrivate *d;
};

#endif
