/***************************************************************************
                          kmymoneyscheduledcalendar.cpp  -  description
                             -------------------
    begin                : Wed Jul 2 2003
    copyright            : (C) 2000-2003 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// ----------------------------------------------------------------------------
// QT Includes
#include <tqpushbutton.h>
#include <tqkeysequence.h>

// ----------------------------------------------------------------------------
// KDE Includes
#include <tdelocale.h>
#include <tdepopupmenu.h>
#include <tdemessagebox.h>

// ----------------------------------------------------------------------------
// Project Includes
#include "../widgets/kmymoneyscheduledcalendar.h"
#include "../mymoney/mymoneyfile.h"

kMyMoneyScheduledCalendar::kMyMoneyScheduledCalendar(TQWidget *parent, const char *name )
  : kMyMoneyCalendar(parent,name)
{
  TQPushButton *pb1 = new TQPushButton(i18n("Select Schedules"), this);

  tdepopupmenu = new TDEPopupMenu(this);
  tdepopupmenu->setCheckable(true);
  tdepopupmenu->insertItem(i18n("Bills"), 0);
  tdepopupmenu->insertItem(i18n("Deposits"), 1);
  tdepopupmenu->insertItem(i18n("Transfers"), 2);
  tdepopupmenu->connectItem(0, this, TQT_SLOT(slotSetViewBills()));
  tdepopupmenu->connectItem(1, this, TQT_SLOT(slotSetViewDeposits()));
  tdepopupmenu->connectItem(2, this, TQT_SLOT(slotSetViewTransfers()));
  tdepopupmenu->setItemChecked(0, true);
  tdepopupmenu->setItemChecked(1, true);
  tdepopupmenu->setItemChecked(2, true);
  pb1->setPopup(tdepopupmenu);

  m_scheduledDateTable = new kMyMoneyScheduledDateTbl(this);
  setDateTable((kMyMoneyDateTbl*)m_scheduledDateTable);

  setUserButton1(true, pb1);

  init( TQDate::currentDate() );

  connect(m_scheduledDateTable, TQT_SIGNAL(enterClicked(const MyMoneySchedule&, const TQDate&)),
    this, TQT_SIGNAL(enterClicked(const MyMoneySchedule&, const TQDate&)));
  connect(m_scheduledDateTable, TQT_SIGNAL(skipClicked(const MyMoneySchedule&, const TQDate&)),
    this, TQT_SIGNAL(skipClicked(const MyMoneySchedule&, const TQDate&)));
}

kMyMoneyScheduledCalendar::~kMyMoneyScheduledCalendar()
{
}

void kMyMoneyScheduledCalendar::slotSetViewBills()
{
  tdepopupmenu->setItemChecked(0, ((tdepopupmenu->isItemChecked(0)) ? false : true));
  m_scheduledDateTable->filterBills(!tdepopupmenu->isItemChecked(0));
}

void kMyMoneyScheduledCalendar::slotSetViewDeposits()
{
  tdepopupmenu->setItemChecked(1, ((tdepopupmenu->isItemChecked(1)) ? false : true));
  m_scheduledDateTable->filterDeposits(!tdepopupmenu->isItemChecked(1));
}

void kMyMoneyScheduledCalendar::slotSetViewTransfers()
{
  tdepopupmenu->setItemChecked(2, ((tdepopupmenu->isItemChecked(2)) ? false : true));
  m_scheduledDateTable->filterTransfers(!tdepopupmenu->isItemChecked(2));
}

#include "kmymoneyscheduledcalendar.moc"
