/***************************************************************************
                          kmymoneycategory.cpp  -  description
                             -------------------
    begin                : Mon Jul 10 2006
    copyright            : (C) 2006 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// ----------------------------------------------------------------------------
// QT Includes

#include <tqrect.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqlayout.h>
#include <tqtimer.h>

// ----------------------------------------------------------------------------
// KDE Includes

#include <tdelocale.h>
#include <kpushbutton.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kguiitem.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "kmymoneycategory.h"
#include <kmymoney/mymoneyfile.h>
#include "kmymoneyaccountcompletion.h"

class KMyMoneyCategory::Private
{
public:
  Private() :
    splitButton(0),
    frame(0),
    recursive(false) {}

  KPushButton*      splitButton;
  TQFrame*           frame;
  bool              recursive;
};

KMyMoneyCategory::KMyMoneyCategory(TQWidget* parent, const char * name, bool splitButton) :
  KMyMoneyCombo(true, parent, name),
  d(new Private)
{
  if(splitButton) {
    d->frame = new TQFrame(0);
    d->frame->setFocusProxy(this);
    TQHBoxLayout* layout = new TQHBoxLayout(d->frame);
    // make sure not to use our own overridden version of reparent() here
    KMyMoneyCombo::reparent(d->frame, getWFlags() & ~WType_Mask, TQPoint(0, 0), true);
    if(parent)
      d->frame->reparent(parent, TQPoint(0, 0), true);

    // create button
    KGuiItem splitButtonItem("",
        TQIconSet(TDEGlobal::iconLoader()->loadIcon("split_transaction", TDEIcon::Small,
        TDEIcon::SizeSmall)), "", "");
    d->splitButton = new KPushButton(splitButtonItem, d->frame, "splitButton");

    layout->addWidget(this, 5);
    layout->addWidget(d->splitButton);
  }

  m_completion = new kMyMoneyAccountCompletion(this, 0);
  connect(m_completion, TQT_SIGNAL(itemSelected(const TQString&)), this, TQT_SLOT(slotItemSelected(const TQString&)));
  connect(this, TQT_SIGNAL(textChanged(const TQString&)), m_completion, TQT_SLOT(slotMakeCompletion(const TQString&)));
}

KMyMoneyCategory::~KMyMoneyCategory()
{
  // make sure to wipe out the frame, button and layout
  if(d->frame && !d->frame->parentWidget())
    d->frame->deleteLater();

  delete d;
}

KPushButton* KMyMoneyCategory::splitButton(void) const
{
  return d->splitButton;
}

void KMyMoneyCategory::setPalette(const TQPalette& palette)
{
  if(d->frame)
    d->frame->setPalette(palette);
  KMyMoneyCombo::setPalette(palette);
}

void KMyMoneyCategory::reparent(TQWidget *parent, WFlags w, const TQPoint& pos, bool showIt)
{
  if(d->frame)
    d->frame->reparent(parent, w, pos, showIt);
  else
    KMyMoneyCombo::reparent(parent, w, pos, showIt);
}

kMyMoneyAccountSelector* KMyMoneyCategory::selector(void) const
{
  return dynamic_cast<kMyMoneyAccountSelector*>(KMyMoneyCombo::selector());
}

void KMyMoneyCategory::setCurrentTextById(const TQString& id)
{
  if(!id.isEmpty())
    setCurrentText(MyMoneyFile::instance()->accountToCategory(id));
  else
    setCurrentText();
  setSuppressObjectCreation(false);
}

void KMyMoneyCategory::slotItemSelected(const TQString& id)
{
  setCurrentTextById(id);

  m_completion->hide();

  if(m_id != id) {
    m_id = id;
    emit itemSelected(id);
  }
}

void KMyMoneyCategory::focusOutEvent(TQFocusEvent *ev)
{
  if(isSplitTransaction()) {
    KComboBox::focusOutEvent(ev);
  } else {
    KMyMoneyCombo::focusOutEvent(ev);
  }
}

void KMyMoneyCategory::focusInEvent(TQFocusEvent *ev)
{
  KMyMoneyCombo::focusInEvent(ev);

  // make sure, we get a clean state before we automagically move the focus to
  // some other widget (like for 'split transaction'). We do this by delaying
  // the emission of the focusIn signal until the next run of the event loop.
  TQTimer::singleShot(0, this, TQT_SIGNAL(focusIn()));
}

void KMyMoneyCategory::setSplitTransaction(void)
{
  setCurrentText(i18n("Split transaction (category replacement)", "Split transaction"));
  setSuppressObjectCreation(true);
}

bool KMyMoneyCategory::isSplitTransaction(void) const
{
  return currentText() == i18n("Split transaction (category replacement)", "Split transaction");
}

void KMyMoneyCategory::setEnabled(bool enable)
{
  if(d->recursive || !d->frame) {
    KMyMoneyCombo::setEnabled(enable);

  } else if(d->frame) {
    d->recursive = true;
    d->frame->setEnabled(enable);
    d->recursive = false;
  }
}

void KMyMoneyCategory::setDisabled(bool disable)
{
  setEnabled(!disable);
}

KMyMoneySecurity::KMyMoneySecurity(TQWidget* parent, const char * name) :
  KMyMoneyCategory(parent, name, false)
{
}

KMyMoneySecurity::~KMyMoneySecurity()
{
}

void KMyMoneySecurity::setCurrentTextById(const TQString& id)
{
  if(!id.isEmpty())
    KMyMoneyCategory::setCurrentText(MyMoneyFile::instance()->account(id).name());
  else
    KMyMoneyCategory::setCurrentText();
}

#include "kmymoneycategory.moc"
