/***************************************************************************
    date                 : Mar 30 2007
    version              : 0.24
    copyright            : (C) 2004-2007 by Holger Danielsson
    email                : holger.danielsson@versanet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGCODECOMPLETION_H
#define CONFIGCODECOMPLETION_H

#include <tqwidget.h>
#include <tqtabwidget.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqspinbox.h>
#include <tqstring.h>

#include <tdeversion.h>
#include <tdelistview.h>
#include <kpushbutton.h>
#include <tdeconfig.h>

/**
  *@author Holger Danielsson
  */

namespace KileWidget { class LogMsg; }

class ConfigCodeCompletion : public TQWidget
{
    Q_OBJECT
  
public: 
   ConfigCodeCompletion(TDEConfig *config, KileWidget::LogMsg *logwidget, TQWidget *parent=0, const char *name=0);
   ~ConfigCodeCompletion();

   void readConfig(void);
   void writeConfig(void);

private:
	enum CompletionPage { TexPage=0, DictionaryPage=1, AbbreviationPage=2, NumPages=3 };

	TDEConfig *m_config;
	KileWidget::LogMsg *m_logwidget;
 
	// tabs, views, pages, wordlists
	TQTabWidget *tab;
	TDEListView *m_listview[NumPages];
	TQWidget *m_page[NumPages];
	TQStringList m_wordlist[NumPages];
	TQStringList m_dirname;

	// button
	KPushButton *add,*remove;

    // Checkboxes/Spinboxes
    TQCheckBox *cb_usecomplete, *cb_autocomplete;
    TQCheckBox *cb_setcursor, *cb_setbullets;
    TQCheckBox *cb_closeenv;
    TQSpinBox *sp_latexthreshold;
    TQLabel *lb_latexthreshold;
	TQCheckBox *cb_autocompletetext;
	TQSpinBox *sp_textthreshold;
	TQLabel *lb_textthreshold;
	TQCheckBox *cb_autocompleteabbrev;
	TQCheckBox *cb_showabbrevview;
	TQCheckBox *cb_citeoutofbraces;

	bool kateCompletionPlugin();

	TDEListView *getListview(TQWidget *page);
	TQString getListname(TQWidget *page);
	void addPage(TQTabWidget *tab, CompletionPage page, const TQString &title, const TQString &dirname);

	void setListviewEntries(CompletionPage page);
	bool getListviewEntries(CompletionPage page);
	bool isListviewEntry(TDEListView *listview, const TQString &filename);
	void updateColumnWidth(TDEListView *listview);

	TQString m_localCwlDir, m_globalCwlDir;
	void getCwlFiles(TQMap<TQString,TQString> &map, TQStringList &list, const TQString &dir);
	void getCwlDirs();

private slots:
   void showPage(TQWidget *page);
   void addClicked();
   void removeClicked();
	void slotListviewClicked(TQListViewItem *);
};

#endif
