/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef GLOBAL_H
#define GLOBAL_H

#include <tqstring.h>
#include "aboutdata.h"

class LikeBack;
class DebugWindow;
class BackgroundManager;
class SystemTray;
class BNPView;
class TDEGlobalAccel;
class TDEMainWindow;
class TDEAboutData;

/** Handle all global variables of the application.
  * This file only declare classes : developer should include
  * the .h files of variables he use.
  * @author S�astien Laot
  */
class KDE_EXPORT Global
{
  private:
	static TQString s_customSavesFolder;
  public:
	// Global Variables:
	static LikeBack          *likeBack;
	static DebugWindow       *debugWindow;
	static BackgroundManager *backgroundManager;
	static SystemTray        *systemTray;
	static BNPView           *bnpView;
	static TDEGlobalAccel      *globalAccel;
	static TDEConfig           *basketConfig;
	static AboutData          basketAbout;

	// Application Folders:
	static void setCustomSavesFolder(const TQString &folder);
	static TQString savesFolder();       /// << @return e.g. "/home/username/.trinity/share/apps/basket/".
	static TQString basketsFolder();     /// << @return e.g. "/home/username/.trinity/share/apps/basket/baskets/".
	static TQString backgroundsFolder(); /// << @return e.g. "/home/username/.trinity/share/apps/basket/backgrounds/".
	static TQString templatesFolder();   /// << @return e.g. "/home/username/.trinity/share/apps/basket/templates/".
	static TQString tempCutFolder();     /// << @return e.g. "/home/username/.trinity/share/apps/basket/temp-cut/".   (was ".tmp/")

	// Various Things:
	static TQString openNoteIcon();      /// << @return the icon used for the "Open" action on notes.
	static TDEMainWindow* mainWindow();
	static TDEConfig* config();
	static TDEAboutData* about() { return &basketAbout; };
};

#endif // GLOBAL_H
