/***************************************************************************
                          docking-configuration.cpp  -  description
                             -------------------
    begin                : Son Aug 3 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "docking-configuration.h"

#include <tqcombobox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqframe.h>

#include <tdelocale.h>

using namespace std;

DockingConfiguration::DockingConfiguration (RadioDocking *docking, TQWidget *parent)
    : StationSelector(parent),
      m_docking(docking),
      m_disableGUIUpdates(false)
{
    TQHBoxLayout *layout  = new TQHBoxLayout();
    TQHBoxLayout *layout2 = new TQHBoxLayout();

    m_labelClickMode = new TQLabel(this);
    layout->addWidget(m_labelClickMode);

    m_comboClickMode = new TQComboBox(this);
    layout->addWidget(m_comboClickMode);

    TQSpacerItem *spacer = new TQSpacerItem( 20, 2, TQSizePolicy::Expanding, TQSizePolicy::Minimum);
    layout->addItem(spacer);

    TQFrame *line = new TQFrame(this);
    line->setFrameShape ( TQFrame::HLine );
    line->setFrameShadow( TQFrame::Sunken );
    layout2->addWidget(line);

    StationSelectorUILayout->expand(2,0);
    StationSelectorUILayout->addMultiCellLayout(layout2, 2, 2, 0, 2);
    StationSelectorUILayout->addMultiCellLayout(layout,  3, 3, 0, 2);

    connect(m_comboClickMode, TQT_SIGNAL(activated( int )), this, TQT_SLOT(slotSetDirty()));

    languageChange();
    slotCancel();
}


DockingConfiguration::~DockingConfiguration ()
{
}


void DockingConfiguration::languageChange()
{
    StationSelector::languageChange();
    m_labelClickMode->setText( i18n( "Left Mouse Click on Tray" ) );

    m_comboClickMode->clear();
    m_comboClickMode->insertItem(i18n("Show/Hide all GUI Elements"));
    m_comboClickMode->insertItem(i18n("Power On/Off"));
}

void DockingConfiguration::slotOK()
{
    if (m_dirty) {
        StationSelector::slotOK();
        bool old = m_disableGUIUpdates;
        m_disableGUIUpdates = true;
        if (m_docking)
            m_docking->setLeftClickAction((LeftClickAction)m_comboClickMode->currentItem());
        m_disableGUIUpdates = old;
        m_dirty = false;
    }
}

void DockingConfiguration::slotCancel()
{
    if (m_dirty) {
        StationSelector::slotCancel();
        if (m_docking)
            m_comboClickMode->setCurrentItem(m_docking->getLeftClickAction());
        m_dirty = false;
    }
}

void DockingConfiguration::slotLeftClickActionChanged(LeftClickAction action)
{
    if (!m_disableGUIUpdates) {
        if (m_docking)
            m_comboClickMode->setCurrentItem(action);
    }
}

void DockingConfiguration::slotSetDirty()
{
    m_dirty = true;
}


#include "docking-configuration.moc"
