/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_ROSEGARDENSPINBOX_H_
#define _RG_ROSEGARDENSPINBOX_H_

#include <tqspinbox.h>
#include <tqstring.h>


class TQWidget;


namespace Rosegarden
{



/**
 * A Combobox that just about handles doubles - you have
 * to set the precision outside of this class if you're
 * using it with TQt designer.  Urch.
 */
class SpinBox : public TQSpinBox
{
    Q_OBJECT
  
public:
    SpinBox(TQWidget *parent = 0, const char *name=0);

    double getDoubleValue() const { return m_doubleValue; }

protected:
    virtual TQString mapValueToText (int value);
    virtual int mapTextToValue(bool *ok);

    double m_doubleValue;
};



}

#endif
