/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2004 Peter Simonsson <psn@linux.se>
  Copyright (C) 2006-2008 Eike Hein <hein@kde.org>
*/

#ifndef KONVERSATIONTOPICLABEL_H
#define KONVERSATIONTOPICLABEL_H

#include <kactivelabel.h>
#include <tdelocale.h>


class TQFontMetrics;
class Server;
class TDEPopupMenu;

namespace Konversation
{

    class TopicLabel : public KActiveLabel
    {
        Q_OBJECT
  

        public:
            explicit TopicLabel(TQWidget *parent = 0, const char *name = 0);
            ~TopicLabel();

            TQSize minimumSizeHint() const;
            TQSize sizeHint() const;
            void setServer(Server* server);

            enum PopupIDs { Copy,CopyUrl,SelectAll,Bookmark };

        public slots:
            virtual void openLink(const TQString& link);
            void setText(const TQString& text);

        signals:
            void setStatusBarTempText(const TQString&);
            void clearStatusBarTempText();
            void popupCommand(int);
            void currentChannelChanged(const TQString&);

        protected:
            void updateSqueezedText();
            TQString rPixelSqueeze(const TQString& text, uint maxPixels);
            uint textWidth(const TQString& text, const TQFontMetrics& fm);
            virtual void contentsMousePressEvent(TQMouseEvent *e);
            virtual void contentsMouseReleaseEvent(TQMouseEvent *e);
            virtual void contentsMouseMoveEvent(TQMouseEvent *e);
            virtual void leaveEvent (TQEvent*);
            virtual void contentsContextMenuEvent(TQContextMenuEvent* ev);
            void resizeEvent(TQResizeEvent*);
            bool contextMenu(TQContextMenuEvent* ce);

            void setupChannelPopupMenu();

        protected slots:
            void highlightedSlot(const TQString&);

        private:
            Server* m_server;

            TQPopupMenu* m_popup;
            TDEPopupMenu* m_channelPopup;

            TQString m_fullText;
            bool mousePressed;
            TQString urlToDrag;
            TQPoint pressPosition;
            TQString m_lastStatusText;
            TQString m_highlightedURL;
            TQString m_currentChannel;
            bool m_isOnChannel;
            int m_nickPopupId;
            int m_channelPopupId;
            bool m_copyUrlMenu;
            TQString m_urlToCopy;

    };

}
#endif
