#ifndef STATUS_H
#define STATUS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <kapp.h>

#include <tdeconfig.h>
#include <tqwidget.h>
#include <tqpixmap.h>
#include <tqstring.h>
#include <tqmemarray.h>
#include <tqptrlist.h>
#include <tqstrlist.h>
#include <tqregexp.h>

class Status : public TQWidget
{
    Q_OBJECT
public:
    Status(TQWidget *parent=0, const char *name=0, int scheme=-1, int mode=-1);
    ~Status() {};

public slots:
    void setScheme(int scheme, int mode);
    void setLevel(int level);
    void setLifes(int lifes);

protected:
    void  paintEvent(TQPaintEvent *);
    int minHeight();
    int minWidth();

    TQString decodeHexOctString(TQString str);

    void fillArray(TQMemArray<int> &, TQString, int);
    void fillStrList(TQStrList &, TQString, int);
    void fillPixmapName(TQStrList &);

    void confScheme();
    void confLevels(bool defGroup=TRUE);
    void confMisc(bool defGroup=TRUE);

    void initPixmaps();

private:
    TQMemArray<int> levelPos;
    int actualLifes;
    int actualLevel;

    TQString pixmapDirectory;

    TQStrList lifesPixmapName;
    TQStrList levelPixmapName;

    TQString lastLifesPixmapName;
    TQString lastLevelPixmapName;

    TQPtrList<TQPixmap> *loadPixmap(TQWidget *parent, TQString pixmapName,
                               TQPtrList<TQPixmap> *pixmaps=0);

    TQPtrList<TQPixmap> *lifesPix;
    TQPtrList<TQPixmap> *levelPix;

    int maxLevel;
    int level;

    int scheme;
    int mode;
};

#endif // STATUS_H
