/***************************************************************************
                          setpageservers.h  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETPAGESERVERS_H
#define SETPAGESERVERS_H

#include <tqtabwidget.h>
#include <kbuttonbox.h>
#include <tdelistview.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <tqlabel.h>
#include <tqhbox.h>
#include <tqstringlist.h>
#include <tqcheckbox.h>
#include <tqwidget.h>
#include <tqgroupbox.h>
#include <tqpushbutton.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqptrlist.h>
#include <tqlayout.h>
#include "resource.h"
#include "dlg_server.h"

/**
  *@author Troy Corbin Jr.
  */

class setPageServers : public TQVBoxLayout
{
   Q_OBJECT
  
	public:
						setPageServers(TQWidget *parent=0, resource *Rsrc=0);
						~setPageServers();
		bool		resetServer;

	public slots:
		void									slotServer_Add( void );
		void									slotServer_Modify( void );
		void									slotServer_Delete( void );

		void									slotCurrent( int );

		void									slot_Premove( bool );
		void									slot_Private( bool );
		void									slot_Profanity( int );
		void									slot_Kibitz( bool );
		void									slot_Tell( bool );
		void									slot_Shout( bool );
		void									slot_Seek( bool );
		void									slot_SeekTimer( int value );
		void									slot_Auto_Close_ICS( bool state );

	signals:
		void									enableApply( void );

	protected slots:
		void									BuildServerData( void );
		void									selectionChanged( void );

	protected:
		void									initTab1( void );
		void									initTab2( void );

	private:
		resource							*Resource;
		int										margin;
		TQTabWidget						*TabParent;
		
													/* Tab 1 : Servers */
		TQVBox									*Tab1;
			TQGroupBox							*GROUP_Current;
			TQGroupBox							*GROUP_Servers;
			KComboBox							*Servers;
			TDEListView							*Servers_ListView;
			KButtonBox						*Servers_ButtonBox;
				TQPushButton					*Servers_Button_Add;
				TQPushButton					*Servers_Button_Change;
				TQPushButton					*Servers_Button_Delete;
			dlg_server						*Server_Dialog;
													/* Tab 2 : Options */
		TQVBox									*Tab2;
			TQGroupBox							*BOX_Profanity;
				KComboBox							*COMBO_Profanity;
			TQCheckBox							*BUTTON_Premove;
			TQCheckBox							*BUTTON_Private;
			TQCheckBox							*BUTTON_Kibitz;
			TQCheckBox							*BUTTON_Tell;
			TQCheckBox							*BUTTON_Shout;
			TQCheckBox							*BUTTON_Seek;
			TQCheckBox							*BUTTON_Auto_Close_ICS;
			TQHBox									*BOX_SeekTimer;
				TQSpinBox							*BUTTON_SeekTimer;
				TQLabel								*LABEL_SeekTimer;
};

#endif
