/**********************************************************************
** Copyright (C) 2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include <tqheader.h>
#include <tqlineedit.h>
#include <tqtimer.h>
#include "listboxrename.h"

class EditableListBoxItem : public TQListBoxItem
{
public:
    void setText( const TQString & text )
    {
	TQListBoxItem::setText( text );
    }
};

ListBoxRename::ListBoxRename( TQListBox * eventSource, const char * name )
    : TQObject( eventSource, name ),
      clickedItem( 0 ), activity( FALSE )
{
    src = eventSource;
    src->installEventFilter( this );
    ed = new TQLineEdit( src->viewport() );
    ed->hide();
    ed->setFrame( FALSE );

    TQObject::connect( ed, TQT_SIGNAL( returnPressed() ),
		      this, TQT_SLOT( renameClickedItem() ) );
}

bool ListBoxRename::eventFilter( TQObject *, TQEvent * event )
{
    switch ( event->type() ) {
	
    case TQEvent::MouseButtonPress:
        {
	    TQPoint pos = ((TQMouseEvent *) event)->pos();
	    
	    if ( clickedItem &&
		 clickedItem->isSelected() &&
		 (clickedItem == src->itemAt( pos )) ) {
		TQTimer::singleShot( 500, this, TQT_SLOT( showLineEdit() ) );
		activity = FALSE; // no drags or clicks for 500 ms before we start the renaming
	    } else { // new item clicked
		activity = TRUE;
		clickedItem = src->itemAt( pos );
		ed->hide();
	    }
	}
        break;
	
    case TQEvent::MouseMove:

	if ( ((TQMouseEvent *) event)->state() & Qt::LeftButton ) {
	    activity = TRUE;  // drag
	}
	break;
	
    case TQEvent::KeyPress:
	
	switch ( ((TQKeyEvent *) event)->key() ) {

	case TQt::Key_F2:
	    
	    activity = FALSE;
	    clickedItem = src->item( src->currentItem() );
	    showLineEdit();
	    break;

	case TQt::Key_Escape:
	    if ( !ed->isHidden() ) {
		hideLineEdit(); // abort rename
		return TRUE;
	    }
	    break;

	case TQt::Key_Up:
	case TQt::Key_Down:
	case TQt::Key_PageUp:
	case TQt::Key_PageDown:
	    
	    if ( !ed->isHidden() )
		return TRUE; // Filter out the keystrokes
	    break;

	}
	break;

    case TQEvent::Resize:

	if ( clickedItem && ed && !ed->isHidden() ) {
	    TQRect rect = src->itemRect( clickedItem );
	    ed->resize( rect.right() - rect.left() - 1,
		rect.bottom() - rect.top() - 1 );
	}
	break;

    default:
	break;
    }
    
    return FALSE;
}

void ListBoxRename::showLineEdit()
{
    if ( !clickedItem || activity )
	return;
    TQRect rect = src->itemRect( clickedItem );
    ed->resize( rect.right() - rect.left() - 1,
		rect.bottom() - rect.top() - 1 );
    ed->move( rect.left() + 1, rect.top() + 1 );
    ed->setText( clickedItem->text() );
    ed->selectAll();
    ed->show();
    ed->setFocus();
}

void ListBoxRename::hideLineEdit()
{
    ed->hide();
    clickedItem = 0;
    src->setFocus();
}

void ListBoxRename::renameClickedItem()
{
    if ( clickedItem && ed ) {
	( (EditableListBoxItem *) clickedItem )->setText( ed->text() );
	emit itemTextChanged( ed->text() );
    }
    hideLineEdit();
}
