#################################################
#
#  (C) 2010 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### find X11

find_package( X11)


##### check for headers

check_include_file( unistd.h   HAVE_UNISTD_H        )
check_include_file( string.h   HAVE_STRING_H        )
check_include_file( sys/time.h HAVE_SYS_TIME_H      )
check_include_file( sys/stat.h HAVE_SYS_STAT_H      )
check_include_file( stdlib.h   HAVE_STDLIB_H        )
check_include_file( stdarg.h   HAVE_STDARG_H        )
check_include_file( time.h     HAVE_TIME_H          )
check_include_file( locale.h   LOCALE_PREFIX        )
check_include_file( pthread.h  USE_XSLDBG_AS_THREAD )


##### check for functions

check_function_exists( gettimeofday HAVE_GETTIMEOFDAY )
check_function_exists( usleep       HAVE_USLEEP       )
check_function_exists( stat         HAVE_STAT         )


if( (BUILD_QUANTA) OR (BUILD_KXSLDBG) OR (BUILD_KLINKSTATUS) )

##### check for icu's c++ standard

    pkg_search_module( ICU_UC icu-uc )
    tde_execute_process(
        COMMAND ${PKG_CONFIG_EXECUTABLE} --variable=CXXFLAGS icu-uc
        OUTPUT_VARIABLE ICU_CXXFLAGS
    )


##### check for libxml-2.0

    pkg_search_module( LIBXML libxml-2.0 )

    if( NOT LIBXML_FOUND )
        tde_message_fatal( "libxml-2.0 is required but was not found on your system" )
      elseif( ${LIBXML_VERSION} VERSION_LESS "2.6" )
        tde_message_fatal( "libxml-2.0 version must be, at least, up to 2.6" )
     else()
        set( LIBXML_2_5 1 )
        tde_save( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
        set( CMAKE_REQUIRED_INCLUDES ${LIBXML_INCLUDE_DIRS} )
        set( CMAKE_REQUIRED_LIBRARIES ${LIBXML_LIBRARIES} )
             check_function_exists( xmlSetEntityReferenceFunc HAVE_INCLUDE_FIX )
        tde_restore( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
    endif( NOT LIBXML_FOUND )


##### check for libxslt

    pkg_search_module( LIBXSLT libxslt )

    if( NOT LIBXSLT_FOUND )
        tde_message_fatal( "libxslt are required, but not found on your system" )
    endif( NOT LIBXSLT_FOUND )


    if( BUILD_QUANTA )
        if( WITH_QUANTA_CVSSERVICE )
            tde_import( cervisia )
            find_file( CVSSERVICE_HEADERS NAMES repository_stub.h cvsservice_stub.h cvsjob_stub.h )
            if( CVSSERVICE_HEADERS )
                set( ENABLE_CVSSERVICE 1 )
                set( CVSSERVICE_LIBRARIES "cvsservice-static;cvsservice-shared" CACHE INTERNAL "tdesdk and embedded cvssercice libs" FORCE )
            else()
                tde_message_fatal( "csv service (cervisia) is required for quanta but not found on your system." )
            endif()
        endif()

        find_program( WGET_EXECUTABLE wget )
        if( NOT WGET_EXECUTABLE )
            message( STATUS "wget (download utility) installation is advised since some quanta's features will make use of It." )
        endif()

        find_program( TIDY_EXECUTABLE NAMES tidy tidy5 )
        if( NOT TIDY_EXECUTABLE )
            message( STATUS "tidy (HTML/XML syntax checker) installation is advised since some quanta's features will make use of It." )
        endif()

        find_program( TDEFILEREPLACE_EXECUTABLE tdefilereplace )
        if( NOT TDEFILEREPLACE_EXECUTABLE )
            message( STATUS "tdefilereplace (Batch search and replace tool - tdeutils) installation is advised since some quanta's features will make use of It." )
        endif()

        find_program( KOMPARE_EXECUTABLE kompare )
        if( NOT KOMPARE_EXECUTABLE )
            message( STATUS "kompare (diff utility - tdesdk) installation is advised since some quanta's features will make use of It." )
        endif()
    endif( BUILD_QUANTA )
    
    
    if( BUILD_KXSLDBG )
        find_package( Threads )
        
        tde_save( CMAKE_REQUIRED_INCLUDES )
            set( CMAKE_REQUIRED_INCLUDES ${LIBXML_INCLUDE_DIRS} )
            check_include_file( "libxml/DOCBparser.h" LIBXML_DOCB_ENABLED     )
            check_include_file( "libxml/xinclude.h"   LIBXML_XINCLUDE_ENABLED )
        tde_restore( CMAKE_REQUIRED_INCLUDES )


##### check for libexslt

        pkg_search_module( LIBEXSLT libexslt )
        if( NOT LIBEXSLT_FOUND )
            tde_message_fatal( "libexlt is required but was not found on your system" )
        endif()


##### check for readline

        find_path( READLINE_INCLUDE_DIR
                   NAMES "readline/readline.h" "readline/history.h"
                   HINTS "/usr/include" "/usr/local/include"
                   DOC "Looking for readline header's path"
        )
        find_library( READLINE_LIBRARY
                      NAMES readline history
                      DOC "Looking for readline libraries"
        )

        if( (READLINE_INCLUDE_DIR) AND ( READLINE_LIBRARY ) )
            set( HAVE_READLINE 1 )
            set( HAVE_HISTORY  1 )
            set( READLINE_LIBRARIES ${READLINE_LIBRARY}        )
            set( READLINE_INCLUDE_DIRS ${READLINE_INCLUDE_DIR} )
         else()
            tde_message_fatal( "readline is required but was not found on your system" )
        endif()
        
##### look for Curses

        tde_save_and_set( CMAKE_REQUIRED_INCLUDES ${READLINE_INCLUDE_DIRS} )
        tde_save_and_set( CMAKE_REQUIRED_LIBRARIES ${READLINE_LIBRARIES} )
        check_c_source_compiles("
            #include <readline/readline.h>
            int main(void)
            {
                char *result = readline(\"prompt\");
                return 0;
            }"
            BUILD_READLINE_STANDALONE
        )
        if( NOT BUILD_READLINE_STANDALONE )
            find_package( Curses )
            if( NOT CURSES_FOUND )
                tde_message_fatal( "(n)curses is required but was not found on your system" )
            endif()
            list( APPEND READLINE_LIBRARIES ${CURSES_LIBRARIES} )
        endif()
        tde_restore( CMAKE_REQUIRED_INCLUDES CMAKE_REQUIRED_LIBRARIES )
    endif( BUILD_KXSLDBG )
endif( (BUILD_QUANTA) OR (BUILD_KXSLDBG) OR (BUILD_KLINKSTATUS) )


##### option other editors

if( WITH_OTHER_EDITORS )
    set( ENABLE_EDITORS 1 )
endif( WITH_OTHER_EDITORS )


##### define TQTDOCDIR

if( BUILD_KOMMANDER )
    if( NOT DEFINED TQTDOCDIR )
        find_path( TQT_DOCDIR ntqsql.html
                   PATHS
                       ${TQTDIR}/doc/html $ENV{TQTDIR}/doc/html
                       /opt/trinity/share/tqt3/doc/html
                       /usr/share/doc/packages/tqt3/html
                       /usr/lib/tqt3/doc
                       /usr/lib/tqt3/doc/html
                       /usr/doc/tqt3/html
                       /usr/doc/tqt3
                       /usr/share/doc/tqt3-doc
                       /usr/share/tqt3/doc/html
                       /usr/X11R6/share/doc/tqt/html
        )
        if( TQT_DOCDIR )
            set( TQTDOCDIR "${TQT_DOCDIR}" )
        endif()
    endif()
endif( BUILD_KOMMANDER )
