/*****************************************************************

Copyright (c) 1996-2001 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <tqtooltip.h>
#include <tqdragobject.h>

#include <klocale.h>
#include <kglobalsettings.h>
#include <konq_operations.h>
#include <kfileitem.h>

#include "showdesktop.h"
#include "kicker.h"
#include "kickerSettings.h"

#include "desktopbutton.h"
#include "desktopbutton.moc"

DesktopButton::DesktopButton( TQWidget* parent )
  : PanelButton( parent, "DesktopButton" )
{
    setToggleButton(true);

    TQToolTip::add(this, i18n("Show desktop"));
    setTitle(i18n("Desktop Access"));
    setIcon("desktop");

    connect( this, TQT_SIGNAL(toggled(bool)), this, TQT_SLOT(showDesktop(bool)) );
    connect( ShowDesktop::the(), TQT_SIGNAL(desktopShown(bool)), this, TQT_SLOT(toggle(bool)) );

    setOn( ShowDesktop::the()->desktopShowing() );
}

void DesktopButton::toggle(bool showDesktop)
{
    KickerTip::enableTipping(false);
    setOn(showDesktop);
    KickerTip::enableTipping(true);
}

void DesktopButton::showDesktop(bool showDesktop)
{
    KickerTip::enableTipping(false);
    ShowDesktop::the()->showDesktop(showDesktop);
    KickerTip::enableTipping(true);
}

void DesktopButton::dragEnterEvent( TQDragEnterEvent *ev )
{
    if ((ev->source() != this) && KURLDrag::canDecode(ev))
        ev->accept(rect());
    else
        ev->ignore(rect());
    PanelButton::dragEnterEvent(ev);
}

void DesktopButton::dropEvent( TQDropEvent *ev )
{
    KURL dPath (  KGlobalSettings::desktopPath() );
    KFileItem item( dPath, TQString::tqfromLatin1( "inode/directory" ), KFileItem::Unknown );
    KonqOperations::doDrop( &item, dPath, ev, this );
    PanelButton::dropEvent(ev);
}

