iconName = 'about_kde'
labelText = 'TDEAboutApplication'

from python_tqt.qt import TQFrame, TQHBoxLayout, TQVBoxLayout, SIGNAL
from tdecore import i18n
from tdeui import TDEAboutApplication, KPushButton, KTextEdit


helpText = ("Typically available via the applications 'Help' menu, this "
            "dialog presents the user with the applications About widget.")

docParts = ('tdeui', 'TDEAboutDialog')

class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('About Application'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showAboutDialog)

    def showAboutDialog(self):
        dlg = TDEAboutApplication(self)
        dlg.show()
