/***************************************************************************
 * copyright            : (C) 2006 Seb Ruiz <me@sebruiz.net>               *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPOD_EXPORTDIALOG_H
#define IPOD_EXPORTDIALOG_H

extern "C" {
#include <gpod/itdb.h>
}

#define KIPI_PLUGIN 1

#include <kdialogbase.h>

#if KIPI_PLUGIN
#include <libkipi/interface.h>
#endif

class TQCheckBox;
class TQHGroupBox;
class TQLabel;
class TQPushButton;
class KComboBox;
class KFileItem;
class KLineEdit;
class TDEListView;
class TDEListViewItem;
class KURL;

namespace IpodExport
{

class ImageList;
class IpodAlbumItem;
class IpodPhotoItem;
class IpodHeader;

class UploadDialog : public KDialogBase
{
    Q_OBJECT
  

    public:
        UploadDialog(
                        #if KIPI_PLUGIN
                        KIPI::Interface* interface,
                        #endif
                        TQString caption, TQWidget *parent=0 );

        ~UploadDialog()
        {
            if( m_itdb )
                itdb_photodb_free( m_itdb );
        }

        static UploadDialog *instance() { return s_instance; }

        TQString ipodModel() const;
        TQString mountPoint() { return m_mountPoint; }
        TQString deviceNode() { return m_deviceNode; }

    private slots:
        void startTransfer();

        void addDropItems( TQStringList filesPath );

        void imageSelected( TQListViewItem *item );
        void gotImagePreview( const KFileItem* , const TQPixmap &pixmap );

        void ipodItemSelected( TQListViewItem *item );
        void ipodShowContextMenu( TQListViewItem * ) { }

        void imagesFilesButtonAdd();
        void imagesFilesButtonRem();

        void createIpodAlbum();
        void deleteIpodAlbum();
        void renameIpodAlbum();

        void refreshDevices();
        void updateSysInfo();

    private:
        void addUrlToList( TQString file );
        bool deleteIpodAlbum( IpodAlbumItem *album );
        bool deleteIpodPhoto( IpodPhotoItem *photo );
        void enableButtons();
        void getIpodAlbums();
        void getIpodAlbumPhotos( IpodAlbumItem *item, Itdb_PhotoAlbum *album );
        Itdb_Artwork *photoFromId( const uint id );
        void reloadIpodAlbum( IpodAlbumItem *item, Itdb_PhotoAlbum *album );

        bool openDevice(); // connect to the ipod

#if KIPI_PLUGIN
        KIPI::Interface *m_interface;
#endif
        Itdb_PhotoDB    *m_itdb;
        Itdb_IpodInfo   *m_ipodInfo;
        IpodHeader      *m_ipodHeader;
        bool             m_transferring;

        TQListViewItem   *m_destinationAlbum;

        TQPushButton     *m_createAlbumButton;
        TQPushButton     *m_removeAlbumButton;
        TQPushButton     *m_renameAlbumButton;
        TQPushButton     *m_addImagesButton;
        TQPushButton     *m_remImagesButton;
        TQPushButton     *m_transferImagesButton;
        ImageList       *m_uploadList;
        TDEListView       *m_ipodAlbumList;
        TQLabel          *m_imagePreview;
        TQLabel          *m_ipodPreview;

        TQHGroupBox      *m_destinationBox;
        TQHGroupBox      *m_urlListBox;

        TQString          m_mountPoint;
        TQString          m_deviceNode;

        static UploadDialog *s_instance;
};

}

#endif // IPOD_EXPORTDIALOG_H
