/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2006-05-16
 * Description : a tool to export GPS data to KML file.
 *
 * Copyright (C) 2006-2007 by Stephane Pontier <shadow dot walker at free dot fr>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef KMLEXPORTCONFIG_H
#define KMLEXPORTCONFIG_H

// KDE includes.

#include <kdialogbase.h>

class TQButtonGroup;
class TQCheckBox;
class TQComboBox;
class TQGridLayout;
class TQGroupBox;
class TQLabel;
class TQLineEdit;
class TQRadioButton;
class TQSpacerItem;

class KColorButton;
class KIntNumInput;
class KURLRequester;

namespace KIPIPlugins 
{
    class KPAboutData;
}

namespace KIPIGPSSyncPlugin 
{

class KMLExportConfig : public KDialogBase
{
    Q_OBJECT
  

public:

    explicit KMLExportConfig( TQWidget* parent = 0, const char* name = 0);
    ~KMLExportConfig();

public:

    TQLabel        *ImageSizeLabel;
    TQLabel        *IconSizeLabel;
    TQLabel        *destinationDirectoryLabel_;
    TQLabel        *FileNameLabel_;
    TQLabel        *DestinationUrlLabel_;
    TQLabel        *GPXFileLabel_;
    TQLabel        *timeZoneLabel_;
    TQLabel        *GPXLineWidthLabel_;
    TQLabel        *GPXColorLabel_;
    TQLabel        *GPXTracksOpacityLabel_;
    TQLabel        *GPXAltitudeLabel_;

    TQGroupBox     *TargetPreferenceGroupBox;

    TQButtonGroup  *buttonGroupTargetType;

    TQRadioButton  *LocalTargetRadioButton_;
    TQRadioButton  *GoogleMapTargetRadioButton_;

    TQLineEdit     *DestinationURL_;
    TQLineEdit     *FileName_;

    TQCheckBox     *GPXTracksCheckBox_;

    TQComboBox     *AltitudeCB_;
    TQComboBox     *timeZoneCB;
    TQComboBox     *GPXAltitudeCB_;

    KColorButton  *GPXTrackColor_;

    KURLRequester *DestinationDirectory_;
    KURLRequester *GPXFileKURLRequester_;

    KIntNumInput  *ImageSizeInput_;
    KIntNumInput  *IconSizeInput_;
    KIntNumInput  *GPXTracksOpacityInput_;
    KIntNumInput  *GPXLineWidthInput_;

public slots:

    void GoogleMapTargetRadioButton__toggled(bool);
    void KMLTracksCheckButton__toggled(bool);

signals:

    void okButtonClicked(); // Signal needed by plugin_kmlexport class

protected:

    TQSpacerItem              *spacer3;
    TQSpacerItem              *spacer4;

    TQGridLayout              *KMLExportConfigLayout;
    TQGridLayout              *SizeGroupBoxLayout;
    TQGridLayout              *TargetPreferenceGroupBoxLayout;
    TQGridLayout              *buttonGroupTargetTypeLayout;

    TDEConfig                  *config_;

    KIPIPlugins::KPAboutData *m_about;

protected:

    void saveSettings();
    void readSettings();

protected slots:

    void slotOk();
    //	void slotOkClicked();
    void slotHelp();
};

} // namespace

#endif // KMLEXPORTCONFIG_H
