#!/usr/bin/env python

import sys
from python_tqt.qt import *

class Test(TQWidget):
    def __init__(self, parent=None, name='Test', f=0):
        TQWidget.__init__(self, parent, name, f)

    def paintEvent(self, e):
        p = TQPainter(self)
        p.setClipRect(e.rect())
        d = 1000
        x1 = 0
        x2 = self.width() - 1
        y1 = 0
        y2 = self.height() - 1
        
        x = (x1+x2)/2
        p.drawLine(x, y1, x+d, y1+d)
        p.drawLine(x, y1, x-d, y1+d)
        p.drawLine(x, y2, x+d, y2-d)
        p.drawLine(x, y2, x-d, y2-d)

        y = (y1+y2)/2
        p.drawLine(x1, y, x1+d, y+d)
        p.drawLine(x1, y, x1+d, y-d)
        p.drawLine(x2, y, x2-d, y+d)
        p.drawLine(x2, y, x2-d, y-d)


if __name__=="__main__":
    a = TQApplication(sys.argv)

    s1 = TQSplitter(TQt.Vertical, None, "main")
    s2 = TQSplitter(TQt.Horizontal, s1, "top")

    t1 = Test(s2)
    t1.setBackgroundColor(TQt.blue.light(180))
    t1.setMinimumSize(50,0)

    t2 = Test(s2)
    t2.setBackgroundColor(TQt.green.light(180))
    s2.setResizeMode(t2, TQSplitter.KeepSize)
    s2.moveToFirst(t2)

    s3 = TQSplitter(TQt.Horizontal, s1, "bottom")

    t3 = Test(s3)
    t3.setBackgroundColor(TQt.red)
    t4 = Test(s3)
    t4.setBackgroundColor(TQt.white)

    t5 = Test(s3)
    t5.setMaximumHeight(250)
    t5.setMinimumSize(80,50)
    t5.setBackgroundColor(TQt.yellow)

    s1.setOpaqueResize(1)
    s2.setOpaqueResize(1)
    s3.setOpaqueResize(1)

    a.setMainWidget(s1)
    s1.show()
    a.exec_loop()
