/***************************************************************************
 *   Copyright (C) 1999-2001 by Bernd Gehrmann and the KDevelop Team       *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _GREPDLG_H_
#define _GREPDLG_H_

#include <tqdialog.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>
#include <kcombobox.h>
#include <klineedit.h>


class TDEConfig;
class KURLRequester;
class TQPushButton;
class GrepViewPart;
class KLineEdit;

class GrepDialog : public TQDialog
{
    Q_OBJECT
  

public:
    GrepDialog( GrepViewPart * part, TQWidget *parent=0, const char *name=0 );
    ~GrepDialog();

    void setPattern(const TQString &pattern)
	{ pattern_combo->setEditText(pattern); }
    void setDirectory(const TQString &dir)
	{ dir_combo->setEditText(dir); }
    void setEnableProjectBox(bool enable);

    TQString patternString() const
	{ return pattern_combo->currentText(); }
    TQString templateString() const
	{ return template_edit->text(); }
    TQString filesString() const
	{ return files_combo->currentText(); }
    TQString excludeString() const
	{ return exclude_combo->currentText(); }
    TQString directoryString() const
	{ return dir_combo->currentText(); }

	bool useProjectFilesFlag() const
		{ return use_project_box->isChecked(); }
	bool regexpFlag() const
		{ return regexp_box->isChecked(); }
	bool recursiveFlag() const
		{ return recursive_box->isChecked(); }
	bool noFindErrorsFlag() const
		{ return no_find_err_box->isChecked(); }
	bool caseSensitiveFlag() const
		{ return case_sens_box->isChecked(); }
	bool keepOutputFlag() const
		{ return keep_output_box->isChecked(); }

	void show();
	void hide();

signals:
    void searchClicked();

private slots:
    void templateActivated(int index);
    void slotSearchClicked();
    void slotPatternChanged( const TQString &);
	void slotSynchDirectory();

private:
    KLineEdit *template_edit;
    KHistoryCombo *pattern_combo;
    KComboBox *files_combo;
    KComboBox *exclude_combo;
    KComboBox * dir_combo;
    KURLRequester * url_requester;

    TQCheckBox *regexp_box;
    TQCheckBox *recursive_box;
    TQCheckBox *use_project_box;
    TQCheckBox *no_find_err_box;
    TQCheckBox *case_sens_box;
    TQCheckBox *keep_output_box;
    TDEConfig* config;
    TQPushButton *search_button;
	TQPushButton *synch_button;
	GrepViewPart * m_part;
};


#endif





