/***************************************************************************
 * $Id: tork.h,v 1.115 2009/08/12 19:41:23 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/


#ifndef _TORK_H_
#define _TORK_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqvaluevector.h>

#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <tdetempfile.h>
#include <tdeconfigskeleton.h>
#include <twinmodule.h>
#include <tdepopupmenu.h>

#include "torkview.h"
#include "torclient.h"
#include "statgraph.h"
#include "popupMessage.h"
#include "torkconfig.h"
#include "version.h"
#include "dcoptork.h"
#include "testprivacyproxy.h"
#include "update.h"
#include "trayicon.h"
#include "upnpmanager.h"
#include "hiddensrvs.h"

class KPrinter;
class TDEToggleAction;
class TDEPopupMenu;
class TDEActionMenu;
class KURL;
class TrayIcon;
class TQLabel;
class KProcIO;
class TorClient;
class TQPoint;
class StatGraph;
class TorkConfig;
class TDEConfigSkeleton;
class TDEConfigSkeletonItem;
class KTempFile;
class KWindModule;
class UPnPManager;
class SetMaxRate;
class MyHidden;
class TestProxy;

//class TQValueVector;

/** Enumeration of types which option values can take */
typedef enum display_status_t {
  DISPLAY_NONE = 0,   /**< An arbitrary string. */
  DISPLAY_QUEUED,         /**< A non-negative integer less than MAX_INT */
} display_status_t;



/**
 * This class serves as the main window for tork.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Robert Hogan <robert@roberthogan.net>
 * @version 0.03
 */
class tork : public TDEMainWindow, virtual public DCOPTork
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    tork();

    /**
     * Default Destructor
     */
    virtual ~tork();

    torkView *m_view;

    TrayIcon *_tray;
    TQDict<TQListViewItem> inodes;
    bool connectedToTor(){return (client!=0) ? true : false;};
    TDEPopupMenu* m_LaunchMenu;
    void anonymousFirefox(){m_view->anonymousFirefox();};
    void anonymousOpera(){m_view->anonymousOpera();};
    void anonymousEmail(){m_view->sendAnonymousEmail(); hide();};
    void anonymizedFirefox(const TQString & url){m_view->anonymizedFirefox(url);};
    void anonymizedOpera(const TQString & url){m_view->anonymizedOpera(url);};
    void anonymousKonversation(){torkify( 0 );};
    void anonymousKopete(){torkify( 1 );};
    void anonymousGaim(){torkify( 2 );};
    void anonymousPidgin(){torkify( 3 );};
    void anonymousKonsole(){torkify( 4 );};
    bool getTDESetting();
    bool routerDiscovered(){ return m_routerDiscovered;};
    void setRouterDiscovered(bool discovered){ m_routerDiscovered = discovered;};

    TQStringList getDiscoveredRouters(){ return discoveredRouters;};
    void setBandwidthFromSysTray(int rate );
    void enableTDEAndLaunchKonqWithUrl(const TQString &);
    int upnpORPort(){ return orPort; };
    int upnpDirPort(){ return dirPort; };
    void setUpnpDirPort(int port){ dirPort=port; };
    void setUpnpORPort(int port){ orPort=port; };

private slots:
    void fileNew();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
    void startTor();
    void startNetStat();
    void stopNetStat();
    void updatePrivoxy();
    void childExited();
    void privoxyExited();
    void netStatExited();
    void filterExited();
    void startFromBeginning();
    void isControllerWorking( );
    void checkRouterDiscovered( );

    
    void changeStatusbar(const TQString& in,const TQString& out);
    void changeCaption(const TQString& text);
    void startController();
    void stopController();
    void receivedOutput(KProcIO *);
    void processFilter(KProcIO *filterproc);
    void receivedNetStatOutput(KProcIO *);
    void toggleTDESetting();
    void enableTDE(bool enable);
    void toggleTDESettingAndLaunchKonq();
    void setTDE(bool set);
    void turnOffTDE();
    void sayWhatImDoing(const TQString& );
    void slotOnItem( int, TQListViewItem *, const TQPoint &, int );
    void slotOnORItem( TQListViewItem * );
    void slotOffItem( );
    void openConfig(const TQCString& page);

    void slotHandle(/*TFunctor *functor*/);
    void noClicked(/*TFunctor *functor*/);
    void popUpClosed();
    void processHashProc(KProcIO *hashproc);
    void toggleTorMon();
    void toggleTorMon2();
    void toggleTorBar();
    void hiddenServices();
    void mixminionHome();
    void networkList();
    void infoUpdated(const TQString &type, const TQString &summary, const TQString &data);
    void shuttingDown();
    void showMyServer();
    void showFirewallEvasion();
    void useNewIdentity();
    void showMyKonqueror();
    void showMyHiddenServices();
    void toggleNonTorTraffic(bool state);
    void toggleTorTraffic(bool state);
    void checkForKonqWindow(WId);
    void configurePrivoxy();
    void warnNoServerInfo();
    void startingPeriodOver();
    void needAlphaVersion( );
    void filterServers( int );
    void toggleIP( int );
    void filterLog( int );
    void filterSubnets( int );
    void filterCountries( int );
    void filterTorTraffic( int );
    void filterNonTorTraffic( int );
    void sortByCountry( );
    void toggleTextFilter( int );
    void createSubnetList( );
    void torkify( int );
    void allowNewIdentityRequests();
    void populateSubNetMenu();
    void populatePseudoMenu();
    void populateCountryMenu();
    void applyPseudonymity( int country_id );
    void checkBandwidthSettings();
    void setTorCaption(const TQString &caption);
    void configureServer(int);
    void configureSecurity( int id );
    void updateServerButton( );
    void torUsedAfterDNSRequest();
    void updateTrayStats(const TQString &,const TQString &,const TQString &,const TQString &);
    void updateTrayIcon(const TQString &);
    void resetExited();
    void switchMode();
    void upnpForwardingOK(kt::UPnPRouter*,const TQString &, bool);
    void upnpForwardingError(kt::UPnPRouter*,const TQString &, bool);
    void routerDiscovered(kt::UPnPRouter* );
    void configureRouter(bool force,bool silent=false);
    void checkForSystemManagedPrivoxy();
    void cannotContactPrivoxy();
    void privacyProxyPassed();

public slots:

    void startPrivoxy();
    void letTorKManagePrivoxy();
    void serverHelp(); 
    void enterContactInfo();
    void fixAddressPort();
    void continueAsClient();
    void updateTorStable();
    void reconnectWithCookie();
    void copyCookie();
    void updateTork();
    void quickConfig();
    void cannotContactTor();
    void showTip();
    void showTipOnStart();
    void runWizard(); 
    void copyOldConfig();
    void shouldIApplySettings();
    void applySettingsToRunningTor();
    bool showUsage();
    bool showSecurityWarnings();
    bool showGuideQuestions();
    bool showApplySettingsQuestions();
    bool contactInfoSet();
    bool showDNSLeaks();
    void readEavesdropping();
    void aboutTorify();
    void aboutTor();
    void showSecurityNotice(const TQString &port);
    void showScreamingNotice(const TQString &port);
    void torClosedConnection();
    void makeTorkStoppable();
    void createService(const TQString& dir,const TQString& port);
    void aboutParanoidMode();
    void processWarning(const TQString& type, const TQString& text);
    void processQuestion(const TQString& type, const TQString& text);
    void updateTorUnstable(); 
    void currentTabChanged(TQWidget* cur );
    void stopTor();
    void resetTor();
    void toggleServerButton( bool on );
    void dummyAction();
    void retryUPnP();
    void allowPlainTextPorts();
    void assignPortToRemove();
    void startEverything();
    void stopTorGracefully();

private:
    void setupAccel();
    void setupActions();
    TQString writeConf();
    TQString writePrivoxyConf();
    void writeCustomOptions(TQTextStream &ts);
    void writeCustomOptions2(TQTextStream &ts);
    void showWarning( display_status_t &msg, const TQString &headline,const TQString &torsaid,const TQString &thismeans, const TQString &type, const TQString &icon, bool always, bool showstopper);
    void askQuestion(display_status_t &msg, const TQString &headline,const TQString &torsaid,const TQString &body,const TQString &question,void (tork::*pt2Func)(), const TQString &type, const TQString &icon, bool persistent, bool showstopper);
    void processQueue();
    bool elementShouldBeUsed(const TDEConfigSkeletonItem* it);
    bool noSpecialProcessing(const TDEConfigSkeletonItem* it, TQTextStream &ts);
    TQString doHashPassword();
    bool queryClose();
    void prepareToShut();
    void filterViewServers( TQValueVector<TQString> &possibleValues, TQListView* &view, TDEPopupMenu* &menu, int id, int column );
    void filterView( TQValueVector<TQString> &possibleValues, TQListView* &view, TDEPopupMenu* &menu, int id, int column );
    TQString createFailSafeCommand( const TQStringList &filterRules, bool set );
    void updateServerClientStatusBar(const TQStringList &client, const TQStringList &server);
    void updateToolBar();

private:

    KPrinter   *m_printer;
    TDEToggleAction *m_toolbarAction;
    TDEToggleAction *m_statusbarAction;
    TDEAction *torkConfigure;
    TDEAction *torkStop;
    TDEAction *torkStart;
    TDEAction *torkUpdateTork;
    TDEAction *torkUpdateStable;
    TDEAction *torkUpdateUnstable;
    TDEAction *torkUpdatePrivoxy;
    TDEAction *torkFirstRunWizard;
    TDEAction *torkTip;
    TDEAction *enableKonqi;
    TDEAction *enableTormon;
    //TDEAction *toggleParanoid;
    TDEAction *browseHiddenServices;
    TDEAction *browseNetworkList;
    TDEAction *toggleTorbar;
    TDEActionMenu* m_ServerFilterButton;
    TDEActionMenu* m_LaunchMenuButton;
    TDEActionMenu* m_LogFilterButton;
    TDEActionMenu* m_TrafficFilterButton;
    TDEPopupMenu* m_ServerFilterMenu;
    TDEPopupMenu* m_LogFilterMenu;
    TDEPopupMenu* m_TrafficFilterMenu;
    TDEPopupMenu* m_TorTrafficFilterMenu;
    TDEPopupMenu* m_NonTorTrafficFilterMenu;
    TDEPopupMenu* m_IPFilterMenu;
    TDEPopupMenu* m_PseudoMenu;
    TDEPopupMenu* m_PseudoMenuEU;
    TDEPopupMenu* m_PseudoMenuSA;
    TDEPopupMenu* m_PseudoMenuAS;
    TDEPopupMenu* m_PseudoMenuNA;
    TDEPopupMenu* m_PseudoMenuAN;
    TDEPopupMenu* m_PseudoMenuAF;
    TDEPopupMenu* m_PseudoMenuNN;
    TDEPopupMenu* m_PseudoMenuOC;
    TDEActionMenu* m_PseudoButton;
    TDEAction* m_IdentityButton;
    TDEAction* m_ModeButton;
    TDEAction* m_UnCensorButton;
    TDEPopupMenu* m_CountryMenu;
    TDEPopupMenu* m_CountryMenuEU;
    TDEPopupMenu* m_CountryMenuSA;
    TDEPopupMenu* m_CountryMenuAS;
    TDEPopupMenu* m_CountryMenuNA;
    TDEPopupMenu* m_CountryMenuAN;
    TDEPopupMenu* m_CountryMenuAF;
    TDEPopupMenu* m_CountryMenuNN;
    TDEPopupMenu* m_CountryMenuOC;
    TDEActionMenu* m_ServerButton;
    TDEPopupMenu* m_ServerButtonMenu;
    TDEActionMenu* m_SecurityButton;
    TDEPopupMenu* m_SecurityButtonMenu;

	TQLabel* m_statusInfo;
	TQLabel* m_statusTransfer;
	TQLabel* m_statusSpeed;
	StatGraph* m_graphIn;
	StatGraph* m_graphOut;
    KProcIO* childproc;
    KProcIO* filterproc;
    KProcIO* netstatproc;
    KProcIO* privoxyproc;
    TorClient* client;
    bool m_servererrornag;
    bool m_contactinfonag;
    bool m_serverworking;
    TQListViewItem* m_prevItem;
    TQTimer *timer;
    TQTimer *bwtimer;
    TQTimer *bwLimitTimer;
    void (tork::*m_pt2Func)();
    KDE::PopupMessage *m_tooltip;
    TQStringList m_list;
    TQString m_body;
    display_status_t* m_msg;
    KProcIO *hashproc;
    TQString m_hashedpassword;
    TDEConfigSkeletonItem::List previtems;
    TDEConfigSkeleton pcopy;
    PrevConfig::PrevConfigList prevlist;
    TorkUpdate* updater;
    KTempFile* tfTor;
    KTempFile* tfPrivoxy;
    KWinModule* winModule;
    TQWidget* prev;

    TQValueList<TQListViewItem*> ordinaryServerList;
    TQMap<TQString,TDEPopupMenu*> continentMap;
    TQMap<TQString,TDEPopupMenu*> continentMapList;
    TQStringList discoveredRouters;

    int filterId;

    bool m_toolTipShowing;
    bool m_persistent;
    bool filterWasApplied;
    bool geoip_db;
    bool waitingForServers;
    bool stillStarting;
    bool m_DNSTorified;
    bool m_showstopperAlreadyDisplayed;
    bool m_routerDiscovered;
    bool recentNewIdentityRequest;
    bool m_ShutdownRequested;
    bool m_AppliedSettings;
    bool m_CanApplyServerSettingsIfSet;

    TQDialog* dialog;
    MyHidden* myHiddenDialog;
    TQDialog* serverdialog;

    UPnPManager* upnpmanager;
    ForwardPortList* forwardPortList;

    TQString filterError;
    TQString torCaption;
    TQString m_program;

	SetMaxRate* m_set_max_rate;

    TestPrivoxy *privoxytest;
    int orPort;
    int dirPort;

};


extern tork *tdemain;

#endif // _TORK_H_

