/***************************************************************************
                          aboutwidget.h  -  description
                             -------------------
    begin                : Sa Sep 13 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_ABOUT_WIDGET_H
#define KRADIO_ABOUT_WIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <tqwidget.h>

/* Unfortunately KDE doesn't provide the class TDEAboutContainerBase
   to public programming, so we have to copy most of that code into
   an own class :(
*/

class TQFrame;
class TDEAboutContainer;
class TQTabWidget;
class TQVBoxLayout;
class TDEAboutData;

#include <tqlabel.h>

// copied (and renamed) from kaboutdialog_private.h
// original: KImageTrackLabel

class TDERadioImageTrackLabel : public TQLabel
{
  Q_OBJECT
  

  public:
    enum MouseMode
    {
      MousePress = 1,
      MouseRelease,
      MouseDoubleClick,
      MouseMove
    };

  public:
    TDERadioImageTrackLabel( TQWidget * parent, const char * name=0, WFlags f=0 );

  signals:
    void mouseTrack( int mode, const TQMouseEvent *e );

  protected:
    virtual void mousePressEvent( TQMouseEvent *e );
    virtual void mouseReleaseEvent( TQMouseEvent *e );
    virtual void mouseDoubleClickEvent( TQMouseEvent *e );
    virtual void mouseMoveEvent ( TQMouseEvent *e );
};

// copied (and renamed) from kaboutdialog_private.h
// original: TDEAboutContainerBase

class TDERadioAboutWidget : public TQWidget
{
  Q_OBJECT
  

  public:
    enum LayoutType
    {
      AbtPlain         = 0x0001,
      AbtTabbed        = 0x0002,
      AbtTitle         = 0x0004,
      AbtImageLeft     = 0x0008,
      AbtImageRight    = 0x0010,
      AbtImageOnly     = 0x0020,
      AbtProduct       = 0x0040,
      AbtKDEStandard   = AbtTabbed|AbtTitle|AbtImageLeft,
      AbtAppStandard   = AbtTabbed|AbtTitle|AbtProduct,
      AbtImageAndTitle = AbtPlain|AbtTitle|AbtImageOnly
    };

  public:
    TDERadioAboutWidget(const TDEAboutData &abtData, int layoutType, TQWidget *parent = 0, char *name = 0);
    virtual void show( void );
    virtual TQSize sizeHint( void ) const;

    void setAboutData(const TDEAboutData &abtData);

    void setTitle( const TQString &title );
    void setImage( const TQString &fileName );
    void setImageBackgroundColor( const TQColor &color );
    void setImageFrame( bool state );
    void setProduct( const TQString &appName, const TQString &version,
             const TQString &author, const TQString &year );

    TQFrame *addTextPage( const TQString &title, const TQString &text,
             bool richText=false, int numLines=10 );
    TQFrame *addLicensePage( const TQString &title, const TQString &text,
             int numLines=10 );
    TDEAboutContainer *addContainerPage( const TQString &title,
      int childAlignment = AlignCenter, int innerAlignment = AlignCenter );
    TDEAboutContainer *addScrolledContainerPage( const TQString &title,
      int childAlignment = AlignCenter, int innerAlignment = AlignCenter );

    TQFrame *addEmptyPage( const TQString &title );

    TDEAboutContainer *addContainer( int childAlignment, int innerAlignment );

  public slots:
    virtual void slotMouseTrack( int mode, const TQMouseEvent *e );
    virtual void slotUrlClick( const TQString &url );
    virtual void slotMailClick( const TQString &name, const TQString &address );

  protected:
    virtual void fontChange( const TQFont &oldFont );

  signals:
    void mouseTrack( int mode, const TQMouseEvent *e );
    void urlClick( const TQString &url );
    void mailClick( const TQString &name, const TQString &address );

  private:
    TQMemArray<TQWidget*>  mContainerList;

    TQVBoxLayout *mTopLayout;
    TDERadioImageTrackLabel *mImageLabel;
    TQLabel  *mTitleLabel;
    TQLabel  *mIconLabel;
    TQLabel  *mVersionLabel;
    TQLabel  *mAuthorLabel;
    TQFrame  *mImageFrame;
    TQTabWidget *mPageTab;
    TQFrame  *mPlainSpace;
};


#endif
