/***************************************************************************
 *
 * tdenetman-connection_setting_gsm_widget.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_CONNECTION_SETTING_GSM_WIDGET_H
#define TDENETWORKMANAGER_CONNECTION_SETTING_GSM_WIDGET_H


// tqt headers
#include <tqwidget.h>
#include <tqlineedit.h>

// tde headers
#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

// tdenm headers
#include "tdenetman-connection_settings_dialog.h"
#include "tdenetman-connection_setting_widget_interface.h"

//class VPNService;
class ConnectionSettingGsmWidget;

namespace ConnectionSettings
{

class Connection;

class GSMWidgetImpl : public WidgetInterface
{
	Q_OBJECT
  
	public:
		GSMWidgetImpl(TDENetworkConnection* conn, TQWidget* parent = NULL, const char* name = NULL, WFlags fl = 0);
		void Activate();
		void Deactivate();
	public slots:
		void dirty();

	private:
		void Init();
		//VPNConfigWidget* getVPNConfigWidget(VPNService* service);

		void setNetworkType(TDEGSMNetworkType::TDEGSMNetworkType);
		TDEGSMNetworkType::TDEGSMNetworkType getNetworkType();

		TDEModemConnection* _gsmsetting;
		ConnectionSettingGsmWidget* _mainWid;

		ConnectionSettingsDialogImpl* _parentdialog;
};

}
#endif /* TDENETWORKMANAGER_CONNECTION_SETTING_GSM_WIDGET_H*/
