/* $Id: xmalloc.h $
 *
 *  malloc routines with failure handling.
 *
 */

#if !defined(_XMALLOC_H)
#define _XMALLOC_H

/* The functions are actually macros so that we can pick up the file and line
   number information for debugging error messages without the user having to
   pass those in every time. */
#define xcalloc(n, size)        x_calloc((n), (size), __FILE__, __LINE__)
#define xmalloc(size)           x_malloc((size), __FILE__, __LINE__)
#define xrealloc(p, size)       x_realloc((p), (size), __FILE__, __LINE__)
#define xstrdup(p)              x_strdup((p), __FILE__, __LINE__)
#define xstrndup(p, size)       x_strndup((p), (size), __FILE__, __LINE__)

/*
 * Prototypes of functions
 */
void* x_malloc(size_t size, const char *file, int line);
void* x_calloc(size_t n, size_t size, const char *file, int line);
void* x_realloc(void *p, size_t size, const char *file, int line);
char* x_strdup(const char *s, const char *file, int line);
char* x_strndup(const char *s, size_t size, const char *file, int line);

#endif /* _XMALLOC_H */
