/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    Portions of this file Copyright 2003
        Mark Hymers         <markh@linuxfromscratch.org>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_ROSEGARDENCOLOURTABLE_H_
#define _RG_ROSEGARDENCOLOURTABLE_H_

#include <map>
#include <tqtable.h>
#include <vector>


class TQWidget;
class ColourList;


namespace Rosegarden
{

class ColourMap;


class ColourTable : public TQTable
{
    Q_OBJECT
  

public:
    typedef std::map<unsigned int, unsigned int, std::less<unsigned int> > ColourList;
    ColourTable(TQWidget *parent, ColourMap &input, ColourList &list);
    void populate_table(ColourMap &input, ColourList &list);
    

signals:
    void entryTextChanged(unsigned int, TQString);
    void entryColourChanged(unsigned int, TQColor);

public slots:
    void slotEditEntry (int, int);

protected:
    std::vector<TQColor> m_colours;

};


}

#endif
