/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef QALCULATE_TDE_UTILS_H
#define QALCULATE_TDE_UTILS_H

#include <vector>
#include <string>
#include <list>
#include <libqalculate/qalculate.h>
#undef insertItem
#undef addItem
#undef setItem
#undef getItem

#include <tqstring.h>
#include <tdeshortcut.h>

class TQLabel;
class TQLineEdit;

struct tree_struct {
	std::string item;
	std::list<tree_struct> items;
	std::list<tree_struct>::iterator it;
	std::list<tree_struct>::reverse_iterator rit;
	std::vector<void*> objects;	
	tree_struct *parent;
	void sort() {
		items.sort();
		for(std::list<tree_struct>::iterator it = items.begin(); it != items.end(); ++it) {
			it->sort();
		}
	}
	bool operator < (tree_struct &s1) const {
		return item < s1.item;	
	}	
};
struct mode_struct {
	PrintOptions po;
	EvaluationOptions eo;
	AssumptionType at;
	AssumptionSign as;
	int precision;
	TQString name;
	bool rpn_mode;
	TDEShortcut shortcut;
};

void insert_text_in_expression(const TQString  &str);
bool is_answer_variable(Variable *v);
TQString get_value_string(const MathStructure &mstruct_, bool rlabel = false, Prefix *prefix = NULL);
void set_name_label_and_entry(ExpressionItem *item, TQLineEdit *entry, TQLabel *label);
bool can_display_unicode_string_function(const char *str, void *arg);
void generate_units_tree_struct();
void generate_functions_tree_struct();
void generate_variables_tree_struct();
size_t save_mode_as(TQString name, bool *new_mode = NULL);

#endif
