#ifndef _SAVETHEMEDIALOG_H_
#define _SAVETHEMEDIALOG_H_
//=============================================================================
//
//   File : savethemedialog.h
//   Created on Wed 03 Jan 2007 03:01:34 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2007 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_pointerlist.h"
#include "kvi_theme.h"

#include <tqdialog.h>
#include <kvi_tal_wizard.h>


class TQLineEdit;
class KviTalTextEdit;
class TQPushButton;
class TQCheckBox;
class TQLabel;
class TQMultiLineEdit;
class KviFileSelector;


class KviSaveThemeDialog : public KviTalWizard
{
	Q_OBJECT
  
public:
	KviSaveThemeDialog(TQWidget * pParent);
	virtual ~KviSaveThemeDialog();
protected:
	TQString m_szScreenshotPath;
	KviFileSelector * m_pImageSelector;
	TQLabel * m_pImageLabel;
	TQLineEdit * m_pThemeNameEdit;
	KviTalTextEdit * m_pThemeDescriptionEdit;
	TQLineEdit * m_pThemeVersionEdit;
	TQLineEdit * m_pAuthorNameEdit;
	TQWidget * m_pImageSelectionPage;
	TQPushButton * m_pOkButton;
protected:
	virtual void accept();
	bool saveTheme();
protected slots:
	void makeScreenshot();
	void imageSelectionChanged(const TQString &szImagePath);
	//void themeNameChanged(const TQString &txt);
};



#endif //!_SAVETHEMEDIALOG_H_
