/***************************************************************************
 *   Copyright (C) 2003-2004 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef ORIENTATIONWIDGET_H
#define ORIENTATIONWIDGET_H

#include <tqguardedptr.h>
#include <tqwidget.h>

class CNItem;
class CNItemGroup;
class FlowPart;
class TQPushButton;

/**
@author David Saxton
*/
class OrientationWidget : public TQWidget
{
Q_OBJECT
  
public:
	OrientationWidget( TQWidget *parent = 0l, const char *name = 0l );
	~OrientationWidget();

public slots:
	void slotUpdate( CNItem *item );
	void slotClear();
	
	void set_cio_noflip_0();
	void set_cio_noflip_90();
	void set_cio_noflip_180();
	void set_cio_noflip_270();
	void set_cio_flip_0();
	void set_cio_flip_90();
	void set_cio_flip_180();
	void set_cio_flip_270();
	
signals:
	void orientationSelected( uint orientation );
	
protected:
	void initFromComponent( Component *component );
	void initFromFlowPart( FlowPart *flowPart );
	
	TQPushButton *m_toolBtn[2][4];
	TQGuardedPtr<FlowPart> p_activeFlowPart;
};

#endif
