/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


//TQt includes
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqvgroupbox.h>
#include <tqbutton.h>
#include <tqradiobutton.h>
#include <tqwhatsthis.h>
#include <tqtooltip.h>

//KDE includes
#include <tdefile.h>
#include <tdelocale.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <tdeapplication.h>
#include <kstandarddirs.h>
#include <kdebug.h>

//Project includes
#include "bootAuthenticationOptions.h"
#include "ksystemlogConfig.h"


BootAuthenticationOptions::BootAuthenticationOptions(TQWidget *parent) :
	TQWidget(parent) 
	{
	
	TQVBoxLayout *layout = new TQVBoxLayout(this);
	layout->setSpacing(10);
	
	//Boot log file
	TQVGroupBox* bootBox=new TQVGroupBox(i18n("Boot Log File"), this);
	
	bootURLRequester=new KURLRequester(bootBox);
	bootURLRequester->setMode(KFile::File);
	
	TQToolTip::add(bootURLRequester, i18n("<qt>Here, you can type or choose the boot log file (example: <i>/var/log/boot.log</i> or <i>/var/log/dmesg</i>).</qt>"));
	TQWhatsThis::add(bootURLRequester, i18n("<qt>You can type or choose here the boot log file. This file will be analyzed by KSystemLog when you choose the <b>Boot log</b> menu item. Generally, the name is <i>/var/log/boot.log</i> or <i>/var/log/dmesg</i></qt>"));

	connect(bootURLRequester, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(onOptionsChanged(const TQString&)));
	
	//Authentication log file
	TQVGroupBox* authenticationBox=new TQVGroupBox(i18n("Authentication Log File"), this);
	
	authenticationURLRequester=new KURLRequester(authenticationBox);
	authenticationURLRequester->setMode(KFile::File);

	TQToolTip::add(authenticationURLRequester, i18n("<qt>Here, you can type or choose the authentication log file (example: <i>/var/log/auth.log</i>).</qt>"));
	TQWhatsThis::add(authenticationURLRequester, i18n("<qt>You can type or choose here the authentication log file. This file will be analyzed by KSystemLog when you will choose the <b>Authentication log</b> menu item. Generally, its name is <i>/var/log/auth.log</i></qt>"));
	
	connect(authenticationURLRequester, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(onOptionsChanged(const TQString&)));
	
	TQSpacerItem* spacer=new TQSpacerItem(0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding);

	layout->addWidget(bootBox);
	layout->addWidget(authenticationBox);
	layout->addItem(spacer);
	
	readConfig();
}


void BootAuthenticationOptions::readConfig() {
	TQString file=KSystemLogConfig::bootPath();
	bootURLRequester->setURL(file);
	
	file=KSystemLogConfig::authenticationPath();
	authenticationURLRequester->setURL(file);
}

void BootAuthenticationOptions::saveConfig() {
	kdDebug() << "Save config from Boot Authentication Options" << endl;
	
	KSystemLogConfig::setBootPath(bootURLRequester->url());
	KSystemLogConfig::setAuthenticationPath(authenticationURLRequester->url());

}

//TODO Please verify that this is OK !
bool BootAuthenticationOptions::isValid() {
	KURL test1(bootURLRequester->url());
	KURL test2(authenticationURLRequester->url());
	
	if (test1.isValid() && test2.isValid())
		return(true);
	else
		return(false);
}


void BootAuthenticationOptions::onOptionsChanged(const TQString& /*text*/) {
	emit optionsChanged(true);
}



#include "bootAuthenticationOptions.moc"
