/*
	mactioneditsdialog.h - An action editor
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MACTIONEDITDIALOG_H__
#define __MACTIONEDITDIALOG_H__

#include "actions.h"

#include <kdialogbase.h>

class TQCheckBox;
class TQComboBox;

class KIntNumInput;
class KLineEdit;
class KPushButton;

/**
 * @short An action editor.
 * Used in @ref MSettingsDialog.
 */
class MActionEditDialog: public KDialogBase
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 * @param parent A parent widget
	 * @param action An action type to edit
	 */
	MActionEditDialog(TQWidget *parent, const Action::Type action);

	/** Destructor. */
	virtual ~MActionEditDialog();
private:
	Action::Type _action;
	TQComboBox *_methods;
	TQLabel
		*l_command,
		*l_title;
	TQString _userCommand;
	KLineEdit *in_command;
	// command before action
	TQCheckBox *c_runCommandBeforeAction;
	KLineEdit *i_commandBeforeAction;
	KIntNumInput *i_commandBeforeActionPause;
	KPushButton *b_testCommandBeforeAction;
	void setMethod(const Action::Method method) const;
protected slots:
	/**
	 * Sets default values.
	 */
	virtual void slotDefault();
private slots:
	void slotMethodChange(int index);
	void slotOKClicked();
	void slotTestCommandBeforeAction();
};

#endif // __MACTIONEDITDIALOG_H__
