/***************************************************************************
 *   Copyright (C) 2007 by Michael Zanetti   *
 *   michael_zanetti@gmx.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "tqlabel.h"

#include "kdebug.h"
#include "tdelocale.h"
#include "klineedit.h"
#include "kurl.h"
#include "krun.h"

#include "smppopup.h"
#include "verifypopup.h"

SMPPopup::SMPPopup(TQWidget* parent, const char* name, TQString title, WFlags fl, ConnContext *context, Kopete::ChatSession *session, bool initiate )
: SMPPopupUI(parent,name,fl)
{
	this->context = context;
	this->session = session;
	this->initiate = initiate;
	if (title.isNull()) {
		question = false;
		tlText->setText( i18n("Please enter the secret passphrase to authenticate %1:").arg(OtrlChatInterface::self()->formatContact(session->members().getFirst()->contactId())));
	}
	else {
		question = true;
		tlText->setText( title );
	}
}

SMPPopup::~SMPPopup()
{
}

/*$SPECIALIZATION$*/
void SMPPopup::cancelSMP()
{
	OtrlChatInterface::self()->abortSMP( context, session );
	this->close();
}

void SMPPopup::respondSMP()
{
	if (question) {
		OtrlChatInterface::self()->respondSMPQ( context, session, tlText->text(), leSecret->text(), initiate );
	}
	else {
		OtrlChatInterface::self()->respondSMP( context, session, leSecret->text(), initiate );
	}
	this->close();
}

void SMPPopup::openHelp()
{
	KURL *url = new KURL("http://www.cypherpunks.ca/otr/help/authenticate.php?lang=en");
	new KRun(*url, 0, false, true);
}

void SMPPopup::manualAuth(){
	VerifyPopup *vfPopup = new VerifyPopup(this, i18n("Verify Fingerprint"), session);
	vfPopup->show();
	this->close();
}

#include "smppopup.moc"

