//
// C++ Interface: komposefullscreenwidget
//
// Description:
//
//
// Author: Hans Oischinger <hans.oischinger@kde-mail.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KOMPOSEFULLSCREENWIDGET_H
#define KOMPOSEFULLSCREENWIDGET_H


#include "komposetaskcontainerwidget.h"
#include "komposesettings.h"


class KRootPixmap;
class KomposeDesktopWidget;
class TDEPopupMenu;

/**
@author Hans Oischinger
*/
class KomposeFullscreenWidget : public KomposeTaskContainerWidget
{
Q_OBJECT
public:
  KomposeFullscreenWidget( int displayType = KOMPOSEDISPLAY_VIRTUALDESKS ,KomposeLayout *l = 0 );

  virtual ~KomposeFullscreenWidget();

  int getHeightForWidth( int w ) const;
  int getWidthForHeight( int h ) const;
  double getAspectRatio();
 
  void setType( int t ) { type = t; initView(); }
  int getType() { return type; }
  
protected:
  void initView();
  void initMenu();
  void createDesktopWidgets();

  void mouseReleaseEvent( TQMouseEvent * );
  void mousePressEvent( TQMouseEvent * );
  void keyPressEvent( TQKeyEvent *e );
  void keyReleaseEvent( TQKeyEvent *e );
//   void paintEvent ( TQPaintEvent * );

  bool focusNeighbourDesk( int direction );

  void destroyChildWidgets();
//   virtual void closeEvent ( TQCloseEvent * e );

protected slots:
  void desktopChanged( KomposeDesktopWidget* desk );

private:
  int type;
  TDEPopupMenu *menu;
  KRootPixmap *rootpix;
  KomposeDesktopWidget *current;
};

#endif
