 /***************************************************************************
 *   Copyright (C) 2005 by Raphael Langerhorst                             *
 *   raphael-langerhorst@gmx.at                                            *
 *                                                                         *
 *   Permission is hereby granted, free of charge, to any person obtaining *
 *   a copy of this software and associated documentation files (the       *
 *   "Software"), to deal in the Software without restriction, including   *
 *   without limitation the rights to use, copy, modify, merge, publish,   *
 *   distribute, sublicense, and/or sell copies of the Software, and to    *
 *   permit persons to whom the Software is furnished to do so, subject to *
 *   the following conditions:                                             *
 *                                                                         *
 *   The above copyright notice and this permission notice shall be        *
 *   included in all copies or substantial portions of the Software.       *
 *                                                                         *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       *
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    *
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*
 *   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR     *
 *   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, *
 *   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR *
 *   OTHER DEALINGS IN THE SOFTWARE.                                       *
 ***************************************************************************/
 
#include <kspread_insertcalendardialog.h>

#include <kdatepicker.h>
#include <kdatewidget.h>
#include <kdebug.h>

#include <tqpushbutton.h>

namespace KSpread
{

InsertCalendarDialog::InsertCalendarDialog(TQWidget* parent, const char* name)
: InsertCalendarDialogBase(parent,name)
{
  this->m_datePicker = NULL;
  
  //we start with a default calendar for the current month;

  TQDate first_day_in_month = TQDate::currentDate();
  first_day_in_month.setYMD(first_day_in_month.year(),first_day_in_month.month(),1);
  
  TQDate last_day_in_month(first_day_in_month.year(),first_day_in_month.month(),first_day_in_month.daysInMonth());
  
  this->m_startDateWidget->setDate(first_day_in_month);
  this->m_endDateWidget->setDate(last_day_in_month);
  
  connect(this->m_selectStartDateButton,TQT_SIGNAL(clicked()),this,TQT_SLOT(showStartDatePicker()));
  connect(this->m_selectEndDateButton,TQT_SIGNAL(clicked()),this,TQT_SLOT(showEndDatePicker()));
  
  connect(this->m_insertButton,TQT_SIGNAL(clicked()),this,TQT_SLOT(accept()));
  connect(this->m_cancelButton,TQT_SIGNAL(clicked()),this,TQT_SLOT(reject()));
}

InsertCalendarDialog::~InsertCalendarDialog()
{
}

bool InsertCalendarDialog::buildDatePickerFrame()
{
  if (m_datePicker)
  {
    delete m_datePicker; //destroyed signal is connected to datePickerDeleted()
  }
  
  m_datePicker = new KDatePicker(NULL,"date picker");
  
  Q_ASSERT(m_datePicker);
  
  if (!m_datePicker)
    return false;
  
  connect(m_datePicker,TQT_SIGNAL(destroyed()),this,TQT_SLOT(datePickerDeleted()));
  
  m_datePicker->setCloseButton(true);
  m_datePicker->move(this->x()+this->width(),this->y());
  m_datePicker->show();
  
  return true;
}

void InsertCalendarDialog::datePickerDeleted()
{
  kdDebug() << "date picker deleted" << endl;
  m_datePicker = NULL;
}

void InsertCalendarDialog::accept()
{
  if (m_datePicker)
    m_datePicker->deleteLater();
  kdDebug() << "insert calendar dialog accepted (insert button clicked)" << endl;
  done(TQDialog::Accepted);
  emit insertCalendar(startDate(),endDate());
}

void InsertCalendarDialog::reject()
{
  if (m_datePicker)
    m_datePicker->deleteLater();
  kdDebug() << "insert calendar dialog rejected (cancel button clicked)" << endl;
  done(TQDialog::Rejected);
}

void InsertCalendarDialog::showStartDatePicker()
{
  if (buildDatePickerFrame())
  {
    connect(m_datePicker,TQT_SIGNAL(dateSelected(TQDate)),this,TQT_SLOT(setStartDate(TQDate)));
    connect(m_datePicker,TQT_SIGNAL(dateEntered(TQDate)),this,TQT_SLOT(setStartDate(TQDate)));
    m_datePicker->setDate(startDate());
  }
}

void InsertCalendarDialog::showEndDatePicker()
{
  if (buildDatePickerFrame())
  {
    connect(m_datePicker,TQT_SIGNAL(dateSelected(TQDate)),this,TQT_SLOT(setEndDate(TQDate)));
    connect(m_datePicker,TQT_SIGNAL(dateEntered(TQDate)),this,TQT_SLOT(setEndDate(TQDate)));
    m_datePicker->setDate(endDate());
  }
}

void InsertCalendarDialog::setStartDate(TQDate date)
{
  this->m_startDateWidget->setDate(date);
}

void InsertCalendarDialog::setEndDate(TQDate date)
{
  this->m_endDateWidget->setDate(date);
}

TQDate InsertCalendarDialog::startDate() const
{
  return this->m_startDateWidget->date();
}

TQDate InsertCalendarDialog::endDate() const
{
  return this->m_endDateWidget->date();
}

}

#include "kspread_insertcalendardialog.moc"
