/* This file is part of the KDE project
   Copyright (C) 2001,2002,2003,2004 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "kchartLegendConfigPage.h"
#include "kchartLegendConfigPage.moc"

#include <tdeapplication.h>
#include <tdelocale.h>
#include <kcolorbutton.h>
#include <tdefontdialog.h>
#include <kiconloader.h>

#include <tqlabel.h>
#include <tqbuttongroup.h>
#include <tqvbuttongroup.h>
#include <tqradiobutton.h>
#include <tqlineedit.h>
#include <tqtooltip.h> 
#include <tqwhatsthis.h>

#include "kchart_params.h"
#include "kchart_factory.h"

#include "KDFrameProfileSection.h"


namespace KChart
{


KChartLegendConfigPage::KChartLegendConfigPage( KChartParams* params,
                                                TQWidget* parent ) :
    TQWidget( parent ),_params( params )
{
  //Layout for 4 blocks
  TQGridLayout* layout = new TQGridLayout( this, 3, 2, KDialog::marginHint(), KDialog::spacingHint() );

  //1. Block: General settings
  TQButtonGroup* gb = new TQButtonGroup( 0, Qt::Vertical, i18n("General"), this );
  gb->layout()->setSpacing(KDialog::spacingHint());
  gb->layout()->setMargin(KDialog::marginHint());
  layout->addWidget( gb, 0, 0 );

  TQGridLayout *grid2 = new TQGridLayout( gb->layout(), 4, 2 );

  TQLabel* lab = new TQLabel( i18n("Title:"), gb );
  TQWhatsThis::add(lab, i18n("Write here the title of the legend, which is displayed at the top of the legend box."));
  grid2->addWidget( lab, 0, 0 );

  title = new TQLineEdit( gb );
  grid2->addWidget( title, 0, 1 );

  // 2. Block: Legend position
  gb = new TQButtonGroup( 0, Qt::Vertical, i18n("Legend Position"), this );
  TQWhatsThis::add(gb, i18n("<qt>Choose the location of the legend on the chart by "
      "clicking a location button.\nUse the central button to <b>hide</b> the legend.</qt>"));
  gb->layout()->setSpacing(KDialog::spacingHint());
  gb->layout()->setMargin(KDialog::marginHint());
  gb->setExclusive( true );

  TQGridLayout *grid1 = new TQGridLayout( gb->layout(), 5, 5 );

  lTopLeft          = addButton( grid1, gb, i18n("Top-Left"),      "chart_legend_topleft",     0, 0 );
  lTopLeftTop       = addButton( grid1, gb, i18n("Top-Left-Top"),  "chart_legend_toplefttop",  0, 1 );
  lTop              = addButton( grid1, gb, i18n("Top"),           "chart_legend_top",         0, 2 );
  lTopRightTop      = addButton( grid1, gb, i18n("Top-Right-Top"), "chart_legend_toprighttop", 0, 3 );
  lTopRight         = addButton( grid1, gb, i18n("Top-Right"),     "chart_legend_topright",    0, 4 );

  lTopLeftLeft      = addButton( grid1, gb, i18n("Top-Left-Left"),   "chart_legend_topleftleft",   1, 0 );
  lTopRightRight    = addButton( grid1, gb, i18n("Top-Right-Right"), "chart_legend_toprightright", 1, 4 );

  lLeft             = addButton( grid1, gb, i18n("Left"),      "chart_legend_left",     2, 0 );
  noLegend          = addButton( grid1, gb, i18n("No Legend"), "chart_legend_nolegend", 2, 2 );
  lRight            = addButton( grid1, gb, i18n("Right"),     "chart_legend_right",    2, 4 );

  lBottomLeftLeft   = addButton( grid1, gb, i18n("Bottom-Left-Left"),    "chart_legend_bottomleftleft",   3, 0 );
  lBottomRightRight = addButton( grid1, gb, i18n("Bottom-Right-Right"),  "chart_legend_bottomrightright", 3, 4 );

  lBottomLeft       = addButton( grid1, gb, i18n("Bottom-Left"),         "chart_legend_bottomleft",       4, 0 );
  lBottomLeftBottom = addButton( grid1, gb, i18n("Bottom-Left-Bottom"),  "chart_legend_bottomleftbottom", 4, 1 );
  lBottom           = addButton( grid1, gb, i18n("Bottom"),              "chart_legend_bottom",           4, 2 );
  lBottomRightBottom= addButton( grid1, gb, i18n("Bottom-Right-Bottom"), "chart_legend_bottomrightbottom",4, 3 );
  lBottomRight      = addButton( grid1, gb, i18n("Bottom-Right"),        "chart_legend_bottomright",      4, 4 );

  gb->setAlignment( TQt::AlignLeft );
  layout->addMultiCellWidget( gb, 1,2, 0,0 );

  // 3. Block: Font
  gb = new TQButtonGroup( 0, Qt::Vertical, i18n("Font"), this );
  TQWhatsThis::add(gb, i18n("This Font box can be used to set different fonts for the legend title and the individual entries."));
  gb->layout()->setSpacing(KDialog::spacingHint());
  gb->layout()->setMargin(KDialog::marginHint());
  layout->addWidget( gb, 0, 1 );

  TQGridLayout *grid4 = new TQGridLayout( gb->layout(), 4, 2 );
  titleLegendFontButton = new TQPushButton( gb );

  lab = new TQLabel( i18n("Legend title font:"), gb );
  grid4->addWidget( lab, 0 ,0 );

  titleLegendFontButton->setText( i18n("Select Font...") );
  TQWhatsThis::add(titleLegendFontButton, i18n("Click here to display the TDE font chooser dialog. You will be able to change the font family, style and size for the legend title."));
  grid4->addWidget( titleLegendFontButton, 1, 0 );

  lab = new TQLabel( i18n("Legend text font:"), gb );
  grid4->addWidget( lab, 2, 0 );
  textLegendFontButton = new TQPushButton( gb );
  textLegendFontButton->setText( i18n("Select Font...") );
  TQWhatsThis::add(textLegendFontButton, i18n("Click here to display the TDE font chooser dialog. You will be able to change the font family, style and size for the legend text."));
  grid4->addWidget( textLegendFontButton, 3, 0 );

  connect( titleLegendFontButton, TQT_SIGNAL(clicked()), 
	   this, TQT_SLOT(changeTitleLegendFont()));
  connect( textLegendFontButton, TQT_SIGNAL(clicked()),
	   this, TQT_SLOT(changeTextLegendFont()));

  // 4. Block: Qt::Orientation
  orientationGroup = new TQVButtonGroup( i18n("Orientation"), this );
  TQWhatsThis::add(orientationGroup, i18n("Select, if the legend's items should be drawn next to each other, or below each other."));
  orientationGroup->setRadioButtonExclusive(true);
  orientationGroup->layout()->setSpacing(KDialog::spacingHint());
  orientationGroup->layout()->setMargin(KDialog::marginHint());
  layout->addWidget( orientationGroup, 1, 1 );

  TQRadioButton* orientation = new TQRadioButton( i18n("Vertically"), orientationGroup );
  orientation = new TQRadioButton( i18n("Horizontally"), orientationGroup );
  Q_UNUSED(orientation);

  // 5. Block: Text Colors
  gb = new TQButtonGroup( 0, Qt::Vertical, i18n("Color"), this );
  TQWhatsThis::add(gb, i18n("This Color box can be used to set different colors for the legend title and text."));
  gb->layout()->setSpacing(KDialog::spacingHint());
  gb->layout()->setMargin(KDialog::marginHint());
  layout->addWidget( gb, 2, 1 );

  TQGridLayout *grid3 = new TQGridLayout( gb->layout(), 6, 2 );

  lab = new TQLabel( i18n("Legend title color:"), gb );
  grid3->addWidget( lab, 0, 0 );

  legendTitleColor = new KColorButton( gb );
  TQWhatsThis::add(legendTitleColor, i18n("Click here to display the TDE Select Color dialog. You will be able to change the color for the legend title."));
  grid3->addWidget( legendTitleColor, 1, 0 );


  lab = new TQLabel( i18n("Legend text color:"), gb );
  grid3->addWidget( lab, 2, 0 );

  legendTextColor = new KColorButton( gb );
  TQWhatsThis::add(legendTextColor, i18n("Click here to display the TDE Select Color dialog. You will be able to change the color for the legend text."));
  grid3->addWidget( legendTextColor, 3, 0 );


  lab = new TQLabel( i18n("Legend frame color:"), gb );
  grid3->addWidget( lab, 4, 0 );

  legendFrameColor = new KColorButton( gb );
  TQWhatsThis::add(legendFrameColor, i18n("Click here to display the TDE Select Color dialog. You will be able to change the color for the legend frame."));

  grid3->addWidget( legendFrameColor, 5, 0 );

  //it's not good but I don't know how
  //to reduce space
  layout->addColSpacing( 1, 300 );
}

void KChartLegendConfigPage::init()
{
    switch( _params->legendPosition())
    {
    case KDChartParams::NoLegend:
        noLegend->setOn( true );
        break;
    case KDChartParams::LegendTop:
        lTop->setOn( true );
        break;
    case KDChartParams::LegendBottom:
        lBottom->setOn( true );
        break;
    case KDChartParams::LegendLeft:
        lLeft->setOn( true );
        break;
    case KDChartParams::LegendRight:
        lRight->setOn( true );
        break;
    case KDChartParams::LegendTopLeft:
        lTopLeft->setOn( true );
        break;
    case KDChartParams::LegendTopLeftTop:
        lTopLeftTop->setOn( true );
        break;
    case KDChartParams::LegendTopLeftLeft:
        lTopLeftLeft->setOn( true );
        break;
    case KDChartParams::LegendTopRight:
        lTopRight->setOn( true );
        break;
    case KDChartParams::LegendTopRightTop:
        lTopRightTop->setOn( true );
        break;
    case KDChartParams::LegendTopRightRight:
        lTopRightRight->setOn( true );
        break;
    case KDChartParams::LegendBottomRight:
        lBottomRight->setOn( true );
        break;
    case KDChartParams::LegendBottomRightBottom:
        lBottomRightBottom->setOn( true );
        break;
    case KDChartParams::LegendBottomRightRight:
        lBottomRightRight->setOn( true );
        break;
    case  KDChartParams::LegendBottomLeft:
        lBottomLeft->setOn( true );
        break;
    case  KDChartParams::LegendBottomLeftBottom:
        lBottomLeftBottom->setOn( true );
        break;
    case  KDChartParams::LegendBottomLeftLeft:
        lBottomLeftLeft->setOn( true );
        break;
    default:
        lRight->setOn( true );
        break;
    }

    title->setText(_params->legendTitleText());

    legendTitleColor->setColor(_params->legendTitleTextColor());

    legendTextColor->setColor(_params->legendTextColor());

    TQColor frameColor(TQt::black);
    bool bFound;
    const KDChartParams::KDChartFrameSettings * legendFrame =
        _params->frameSettings( KDChartEnums::AreaLegend, bFound );
    if( bFound )
    {
        const KDFrameProfileSection * top =
            const_cast<KDFrameProfile&>(legendFrame->frame().profile( KDFrame::ProfileTop )).first();
        if( top )
            frameColor = top->pen().color();
    }
    legendFrameColor->setColor(frameColor);

    if( _params->legendOrientation() == Qt::Vertical )
        orientationGroup->setButton(0);
    else
        orientationGroup->setButton(1);

    titleLegend = _params->legendTitleFont();
    titleLegendIsRelative = _params->legendTitleFontUseRelSize()
                          ? TQButton::On
                          : TQButton::Off;
    if( TQButton::On == titleLegendIsRelative )
        titleLegend.setPointSize( _params->legendTitleFontRelSize() );

    textLegend=_params->legendFont();
    textLegendIsRelative = _params->legendFontUseRelSize()
                         ? TQButton::On
                         : TQButton::Off;
    if( TQButton::On == textLegendIsRelative )
        textLegend.setPointSize(_params->legendFontRelSize());
}

void KChartLegendConfigPage::changeTitleLegendFont()
{
    TQButton::ToggleState state = titleLegendIsRelative;
    if (    TDEFontDialog::getFont( titleLegend,false,this, true,&state ) != TQDialog::Rejected
         && TQButton::NoChange != state )
        titleLegendIsRelative = state;
}

void KChartLegendConfigPage::changeTextLegendFont()
{
    TQButton::ToggleState state = textLegendIsRelative;
    if (    TDEFontDialog::getFont( textLegend,false,this, true,&state ) != TQDialog::Rejected
         && TQButton::NoChange != state )
        textLegendIsRelative = state;
}

void KChartLegendConfigPage::apply()
{
    if( noLegend->isOn() )
        _params->setLegendPosition( KDChartParams::NoLegend );
    else if( lTop->isOn() )
        _params->setLegendPosition( KDChartParams::LegendTop );
    else if( lBottom->isOn() )
        _params->setLegendPosition( KDChartParams::LegendBottom );
    else if( lLeft->isOn() )
        _params->setLegendPosition( KDChartParams::LegendLeft );
    else if( lRight->isOn() )
        _params->setLegendPosition( KDChartParams::LegendRight );
    else if( lTopLeft->isOn() )
        _params->setLegendPosition( KDChartParams::LegendTopLeft );
    else if( lTopLeftTop->isOn() )
        _params->setLegendPosition( KDChartParams::LegendTopLeftTop );
    else if( lTopLeftLeft->isOn() )
        _params->setLegendPosition( KDChartParams::LegendTopLeftLeft );
    else if( lTopRight->isOn() )
        _params->setLegendPosition( KDChartParams::LegendTopRight );
    else if( lTopRightTop->isOn() )
        _params->setLegendPosition( KDChartParams::LegendTopRightTop );
    else if( lTopRightRight->isOn() )
        _params->setLegendPosition( KDChartParams::LegendTopRightRight );
    else if( lBottomRight->isOn() )
        _params->setLegendPosition( KDChartParams::LegendBottomRight );
    else if( lBottomRightBottom->isOn() )
        _params->setLegendPosition( KDChartParams::LegendBottomRightBottom );
    else if( lBottomRightRight->isOn() )
        _params->setLegendPosition( KDChartParams::LegendBottomRightRight );
    else if( lBottomLeft->isOn() )
        _params->setLegendPosition( KDChartParams::LegendBottomLeft );
    else if( lBottomLeftBottom->isOn() )
        _params->setLegendPosition( KDChartParams::LegendBottomLeftBottom );
    else if( lBottomLeftLeft->isOn() )
        _params->setLegendPosition( KDChartParams::LegendBottomLeftLeft );
    else
        _params->setLegendPosition( KDChartParams::LegendRight );

    if( orientationGroup->selectedId() == 0 )
        _params->setLegendOrientation( Qt::Vertical );
    else
        _params->setLegendOrientation( Qt::Horizontal );

    _params->setLegendTitleText(title->text());
    _params->setLegendTitleTextColor(legendTitleColor->color());
    _params->setLegendTextColor(legendTextColor->color());

    const TQColor frameColor(legendFrameColor->color());
    if( frameColor == TQt::black )
        _params->removeFrame( KDChartEnums::AreaLegend );
    else
        _params->setSimpleFrame( KDChartEnums::AreaLegend,
            0,0,  0,0,
            true,
            true,
            KDFrame::FrameFlat,
            1,
            0,
            frameColor );

    _params->setLegendTitleFont(titleLegend, TQButton::Off == titleLegendIsRelative);
    if( TQButton::On == titleLegendIsRelative )
        _params->setLegendTitleFontRelSize(titleLegend.pointSize());
    _params->setLegendFont(textLegend, TQButton::Off == textLegendIsRelative);
    if( TQButton::On == textLegendIsRelative )
        _params->setLegendFontRelSize(textLegend.pointSize());
}

TQPushButton* KChartLegendConfigPage::addButton( TQGridLayout* layout,
                                                TQButtonGroup* gb,
                                                const TQString &toolTipText,
                                                const TQString &icon,
                                                int posY,
                                                int posX )
{
  TQPushButton* button = new TQPushButton( gb );
  button->setToggleButton( true );
  button->setPixmap( BarIcon( icon,
                              TDEIcon::SizeMedium,
                              TDEIcon::DefaultState,
                              KChartFactory::global() ) );
  TQToolTip::add( button, toolTipText );
  layout->addWidget( button, posY, posX );
  return button;
}

}  //KChart namespace
