/*
 *  Copyright (c) 2002 Patrick Julien <freak@codepimps.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#ifndef KIS_IMAGE_MAGICK_CONVERTER_H_
#define KIS_IMAGE_MAGICK_CONVERTER_H_

#include <tqobject.h>
#include <tqvaluevector.h>

#include <tdeio/job.h>

#include "kis_types.h"
#include "kis_global.h"
#include "kis_progress_subject.h"

class TQString;
class KURL;
class KisDoc;
class KisNameServer;
class KisUndoAdapter;
/**
 * Image import/export plugins can use these results to report about success or failure.
 */
enum KisImageBuilder_Result {
        KisImageBuilder_RESULT_FAILURE = -400,
        KisImageBuilder_RESULT_NOT_EXIST = -300,
        KisImageBuilder_RESULT_NOT_LOCAL = -200,
        KisImageBuilder_RESULT_BAD_FETCH = -100,
        KisImageBuilder_RESULT_INVALID_ARG = -50,
        KisImageBuilder_RESULT_OK = 0,
        KisImageBuilder_RESULT_PROGRESS = 1,
        KisImageBuilder_RESULT_EMPTY = 100,
        KisImageBuilder_RESULT_BUSY = 150,
        KisImageBuilder_RESULT_NO_URI = 200,
        KisImageBuilder_RESULT_UNSUPPORTED = 300,
        KisImageBuilder_RESULT_INTR = 400,
        KisImageBuilder_RESULT_PATH = 500,
        KisImageBuilder_RESULT_UNSUPPORTED_COLORSPACE = 600
};



/**
 * Build a KisImage representation of an image file.
 */
class KisImageMagickConverter : public KisProgressSubject {
    typedef TQObject super;
    Q_OBJECT
  

public:
    KisImageMagickConverter(KisDoc *doc, KisUndoAdapter *adapter);
    virtual ~KisImageMagickConverter();

public slots:
    virtual void cancel();

public:
    KisImageBuilder_Result buildImage(const KURL& uri);
    KisImageBuilder_Result buildFile(const KURL& uri, KisPaintLayerSP layer, vKisAnnotationSP_it annotationsStart, vKisAnnotationSP_it annotationsEnd);
    KisImageSP image();

public:
    static TQString readFilters();
    static TQString writeFilters();

private slots:
    void ioData(TDEIO::Job *job, const TQByteArray& data);
    void ioResult(TDEIO::Job *job);
    void ioTotalSize(TDEIO::Job *job, TDEIO::filesize_t size);

private:
    KisImageMagickConverter(const KisImageMagickConverter&);
    KisImageMagickConverter& operator=(const KisImageMagickConverter&);
    void init(KisDoc *doc, KisUndoAdapter *adapter);
    KisImageBuilder_Result decode(const KURL& uri, bool isBlob);

private:
    KisImageSP m_img;
    KisDoc *m_doc;
    KisUndoAdapter *m_adapter;
    TQValueVector<TQ_UINT8> m_data;
    TDEIO::TransferJob *m_job;
    TDEIO::filesize_t m_size;
    bool m_stop;
};

#endif // KIS_IMAGE_MAGICK_CONVERTER_H_

