/***************************************************************************
                          tab_seeklist.h  -  description
                             -------------------
    begin                : Sat Sep 14 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAB_SEEKLIST_H
#define TAB_SEEKLIST_H

#include <tdepopupmenu.h>
#include <tdelistview.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include "command.h"

/**
  *@author Troy Corbin Jr.
  */

class resource;

class tab_SeekList : public TDEListView
{
	Q_OBJECT
  

	private:
		resource				*myResource;
		TDEPopupMenu			*menuSeek;
		bool						seek;
		int							selectedMatchID;
		TQString					selectedPlayerName;
		/*
				These StringLists temporarily store Sought Game data
				until all ads have been displayed.
		*/
		TQStringList			SF_01;
		TQStringList			SF_02;
		TQStringList			SF_03;
		TQStringList			SF_04;
		TQStringList			SF_05;
		TQStringList			SF_06;
		TQStringList			SF_07;

	public:
										tab_SeekList(TQWidget *parent=0, const char *name=0, resource *Rsrc=0);
										~tab_SeekList();

	public slots:
		void						recvCMD( const Command& );
		void						display_menuSeek( TQListViewItem*, const TQPoint&, int );
		void						selectMatch( TQListViewItem *Item );
		void						selectMatch( int );
		void						menuFunct( int );

	signals:
		void						sendCMD( const Command& );

	protected:
		void						addSoughtItem( const TQString& );
		void						updateSoughtList( void );

};

#endif
