/***************************************************************************
                          tab_pgnview.cpp  -  description
                             -------------------
    begin                : Sat Jan 25 2003
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tab_pgnview.moc"
#include "tabmanager.h"
#include "resource.h"
#include "pgn.h"
#include <tqfile.h>
#include <tqregexp.h>
#include <tqtextstream.h>
#include <kstddirs.h>
#include <tdetempfile.h>

tab_pgnView::tab_pgnView(pgn *parent, resource *Rsrc ) : KnightsTextView(0,Rsrc)
{
	myParent = parent;
	whiteImage = NULL;
	blackImage = NULL;

	TQString source = locate( "appdata", "pgn_template.kml" );
	TQFile file( source );
	if( file.open( IO_ReadOnly ) )
	{
		TQTextStream stream( &file );
		document = stream.read();
		file.close();
	}
	else
	{
		kdWarning() << "tab_pgnView::tab_pgnView: Can not find PGN Template" << endl;
	}
}

tab_pgnView::~tab_pgnView()
{
	if( whiteImage )
		delete whiteImage;
	if( blackImage )
		delete blackImage;
}
///////////////////////////////////////
//
//	tab_pgnView::init
//
///////////////////////////////////////
void tab_pgnView::init( void )
{
	/* Replace macros with data */
	document.replace( TQRegExp( "%site%" ), myParent->TAG_Site );
	document.replace( TQRegExp( "%date%" ), myParent->TAG_Date );
	document.replace( TQRegExp( "%round%" ), myParent->TAG_Round );
	document.replace( TQRegExp( "%result%" ), myParent->TAG_Result );
	document.replace( TQRegExp( "%white%" ), myParent->TAG_White );
	document.replace( TQRegExp( "%whitetitle%" ), myParent->TAG_WhiteTitle );
	document.replace( TQRegExp( "%whiteelo%" ), myParent->TAG_WhiteElo );
	document.replace( TQRegExp( "%whiteuscf%" ), myParent->TAG_WhiteUSCF );
	document.replace( TQRegExp( "%whitena%" ), myParent->TAG_WhiteNA );
	document.replace( TQRegExp( "%whitetype%" ), myParent->TAG_WhiteType );
	document.replace( TQRegExp( "%black%" ), myParent->TAG_Black );
	document.replace( TQRegExp( "%blacktitle%" ), myParent->TAG_BlackTitle );
	document.replace( TQRegExp( "%blackelo%" ), myParent->TAG_BlackElo );
	document.replace( TQRegExp( "%blackuscf%" ), myParent->TAG_BlackUSCF );
	document.replace( TQRegExp( "%blackna%" ), myParent->TAG_BlackNA );
	document.replace( TQRegExp( "%blacktype%" ), myParent->TAG_BlackType );
	document.replace( TQRegExp( "%time%" ), myParent->TAG_Time );
	document.replace( TQRegExp( "%utctime%" ), myParent->TAG_UTCTime );
	document.replace( TQRegExp( "%utcdate%" ), myParent->TAG_UTCDate );
	document.replace( TQRegExp( "%event%" ), myParent->TAG_Event );
	document.replace( TQRegExp( "%eventdate%" ), myParent->TAG_EventDate );
	document.replace( TQRegExp( "%eventsponsor"), myParent->TAG_EventSponsor );
	document.replace( TQRegExp( "%section%" ), myParent->TAG_Section );
	document.replace( TQRegExp( "%stage%" ), myParent->TAG_Stage );
	document.replace( TQRegExp( "%board%" ), myParent->TAG_Board );
	document.replace( TQRegExp( "%opening%" ), myParent->TAG_Opening );
	document.replace( TQRegExp( "%variation%" ), myParent->TAG_Variation );
	document.replace( TQRegExp( "%subvariation%" ), myParent->TAG_SubVariation );
	document.replace( TQRegExp( "%eco%" ), myParent->TAG_ECO );
	document.replace( TQRegExp( "%nic%" ), myParent->TAG_NIC );
	document.replace( TQRegExp( "%timecontrol%" ), myParent->TAG_TimeControl );
	document.replace( TQRegExp( "%termination%" ), myParent->TAG_Termination );
	document.replace( TQRegExp( "%setup%" ), myParent->TAG_SetUp );
	document.replace( TQRegExp( "%fen%" ), myParent->TAG_FEN );
	document.replace( TQRegExp( "%annotator%" ), myParent->TAG_Annotator );
	document.replace( TQRegExp( "%mode%" ), myParent->TAG_Mode );
	document.replace( TQRegExp( "%plycount%" ), myParent->TAG_PlyCount );

	/* Get the White Player's Image */
	TQPixmap wi = myResource->loadSCIDImage( myParent->TAG_White );
	if( wi.isNull() )
	{
		if( myParent->TAG_WhiteType == "program" )
			wi.load( locate("data", "knights/default-engine-portrait.jpg" ) );
		else
			wi.load( locate("data", "knights/default-portrait.jpg" ) );
	}
	whiteImage = new KTempFile();
	whiteImage->setAutoDelete( TRUE );
	wi.save( whiteImage->name(), "PNG" );
	document.replace( TQRegExp( "%whiteimage%" ), whiteImage->name() );

	/* Get the Black Player's Image */
	TQPixmap bi = myResource->loadSCIDImage( myParent->TAG_Black );
	if( bi.isNull() )
	{
		if( myParent->TAG_BlackType == "program" )
			bi.load( locate("data", "knights/default-engine-portrait.jpg" ) );
		else
			bi.load( locate("data", "knights/default-portrait.jpg" ) );
	}
	blackImage = new KTempFile();
	blackImage->setAutoDelete( TRUE );
	bi.save( blackImage->name(), "PNG" );
	document.replace( TQRegExp( "%blackimage%" ), blackImage->name() );

	/* Obtain the move data */
	TQString moves;
	TQStringList *list;
	if( myParent->Move_Data.isEmpty() )
	{
		list = myParent->notation(2);
	}
	else
	{
		list = new TQStringList( myParent->Move_Data );
	}

	/* Do some formatting and then merge the strings */
	for( TQStringList::Iterator i = list->begin(); i != list->end(); i++ )
	{
		(*i).replace( TQRegExp( "[^\\0040-\\0176]" ), "" );
		(*i).replace( TQRegExp( "\\(" ), "<i>(" );
		(*i).replace( TQRegExp( "\\)" ), ")</i>" );
		(*i).replace( TQRegExp( "\\{" ), "<b>{" );
		(*i).replace( TQRegExp( "\\}" ), "}</b>" );
	}
	moves = list->join( " " );
	delete list;

	int pos = document.find( "%moves%" );
	if( pos != -1 )
	{
		document.remove( (unsigned int)pos, 7 );
		document.insert( (unsigned int)pos, moves );
	}
	setText( document );
}
