/***************************************************************************
                          dlg_promote.cpp  -  description
                             -------------------
    begin                : Fri Jul 13 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "definitions.h"
#include "dlg_promote.moc"
#include "knightspixcache.h"
#include <tqimage.h>

dlg_promote::dlg_promote(TQWidget *parent, const char *name, resource *Rsrc  ) :
	TQDialog( parent, name, TRUE, TQt::WStyle_Customize | TQt::WStyle_DialogBorder )
{
	Resource = Rsrc;
	Queen = new TQPushButton( this );
	Bishop = new TQPushButton( this );
	Knight = new TQPushButton( this );
	Rook = new TQPushButton( this );
	Description = new TQLabel( this );
}

dlg_promote::~dlg_promote()
{
	delete Queen;
	delete Bishop;
	delete Knight;
	delete Rook;
	delete Description;
}

void dlg_promote::Init( bool Army )
{
	KnightsPixCache *cache = Resource->pixCache;
	TQImage tempImage;
	TQPixmap buffer;
	int margin;

	margin = 2;
	buffer.resize( Resource->ThemeSize, Resource->ThemeSize );
	Description->setFixedSize( Resource->ThemeSize * 2 , 20 );
	Queen->setFixedSize( Resource->ThemeSize, Resource->ThemeSize );
	Bishop->setFixedSize( Resource->ThemeSize, Resource->ThemeSize );
	Knight->setFixedSize( Resource->ThemeSize, Resource->ThemeSize );
	Rook->setFixedSize( Resource->ThemeSize, Resource->ThemeSize );
	setFixedSize(	( margin * 4 ) + ( Resource->ThemeSize * 2 ),
								( margin * 6 ) + ( Resource->ThemeSize * 2 ) + 20 );

	Description->move( margin, margin );
	Queen->move( margin, ( margin * 3 ) + 20 );
	Bishop->move( ( margin * 3 ) + Resource->ThemeSize, ( margin * 3 ) + 20 );
	Knight->move( margin, ( margin * 5 ) + 20 + Resource->ThemeSize );
	Rook->move( ( margin * 3 ) + Resource->ThemeSize, ( margin * 5 ) + 20 + Resource->ThemeSize );
	
	/* Queen */
	buffer = cache->SquareLight;
	if( Army == WHITE ) bitBlt( TQT_TQPAINTDEVICE(&buffer), 0, 0, TQT_TQPAINTDEVICE(&cache->WhiteQueen), 0, 0, -1, -1, TQt::CopyROP, FALSE);
	else bitBlt( TQT_TQPAINTDEVICE(&buffer), 0, 0, TQT_TQPAINTDEVICE(&cache->BlackQueen), 0, 0, -1, -1, TQt::CopyROP, FALSE);
	Queen->setPixmap( buffer );
	Queen->show();

	/* Bishop */
	buffer = cache->SquareDark;
	if( Army == WHITE ) bitBlt( TQT_TQPAINTDEVICE(&buffer), 0, 0, TQT_TQPAINTDEVICE(&cache->WhiteBishop), 0, 0, -1, -1, TQt::CopyROP, FALSE);
	else bitBlt( TQT_TQPAINTDEVICE(&buffer), 0, 0, TQT_TQPAINTDEVICE(&cache->BlackBishop), 0, 0, -1, -1, TQt::CopyROP, FALSE);
	Bishop->setPixmap( buffer );
	Bishop->show();

	/* Knight */
	buffer = cache->SquareDark;
	if( Army == WHITE ) bitBlt( TQT_TQPAINTDEVICE(&buffer), 0, 0, TQT_TQPAINTDEVICE(&cache->WhiteKnight), 0, 0, -1, -1, TQt::CopyROP, FALSE);
	else bitBlt( TQT_TQPAINTDEVICE(&buffer), 0, 0, TQT_TQPAINTDEVICE(&cache->BlackKnight), 0, 0, -1, -1, TQt::CopyROP, FALSE);
	Knight->setPixmap( buffer );
	Knight->show();

	/* Rook */
	buffer = cache->SquareLight;
	if( Army == WHITE ) bitBlt( TQT_TQPAINTDEVICE(&buffer), 0, 0, TQT_TQPAINTDEVICE(&cache->WhiteRook), 0, 0, -1, -1, TQt::CopyROP, FALSE);
	else bitBlt( TQT_TQPAINTDEVICE(&buffer), 0, 0, TQT_TQPAINTDEVICE(&cache->BlackRook), 0, 0, -1, -1, TQt::CopyROP, FALSE);
	Rook->setPixmap( buffer );	
	Rook->show();

	Description->setText( i18n( "Promote your pawn to..." ) );
	Description->show();
	connect( Queen, TQT_SIGNAL( clicked() ), this, TQT_SLOT( queenClick() ) );
	connect( Bishop, TQT_SIGNAL( clicked() ), this, TQT_SLOT( bishopClick() ) );
	connect( Knight, TQT_SIGNAL( clicked() ), this, TQT_SLOT( knightClick() ) );
	connect( Rook, TQT_SIGNAL( clicked() ), this, TQT_SLOT( rookClick() ) );
	Queen->setFocus();
	setCaption( i18n( "Pawn Promotion" ) );
}

void dlg_promote::queenClick( void )
{
	done( 'q' );
}

void dlg_promote::bishopClick( void )
{
	done( 'b' );
}

void dlg_promote::knightClick( void )
{
	done( 'n' );
}

void dlg_promote::rookClick( void )
{
	done( 'r' );
}

